/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class TimeZoneManagerImpl
implements TimeZoneManager {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;

    public TimeZoneManagerImpl(JiraAuthenticationContext jiraAuthenticationContext, UserPreferencesManager userPreferencesManager, ApplicationProperties applicationProperties, UserManager userManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPreferencesManager = userPreferencesManager;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
    }

    public TimeZone getLoggedInUserTimeZone() {
        return this.getTimeZoneforUser(this.jiraAuthenticationContext.getUser());
    }

    public TimeZone getTimeZoneforUser(ApplicationUser user) {
        if (this.userManager.isUserExisting(user)) {
            String timezoneId;
            Preferences preferences = this.userPreferencesManager.getPreferences(user);
            String string = timezoneId = preferences != null ? preferences.getString("jira.user.timezone") : null;
            if (StringUtils.isNotEmpty((String)timezoneId)) {
                return TimeZone.getTimeZone(timezoneId);
            }
        }
        return this.getDefaultTimezone();
    }

    public TimeZone getDefaultTimezone() {
        String systemDefaultTimeZoneId = this.applicationProperties.getString("jira.default.timezone");
        if (StringUtils.isNotEmpty((String)systemDefaultTimeZoneId)) {
            return TimeZone.getTimeZone(systemDefaultTimeZoneId);
        }
        return TimeZone.getDefault();
    }
}

