/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build6039;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class UpgradeTask_Build6096
extends UpgradeTask_Build6039 {
    private static final Pattern REGEX_RECYCLED_USED = Pattern.compile("^ID\\d+$");

    public UpgradeTask_Build6096(EntityEngine entityEngine) {
        super(entityEngine);
    }

    @Override
    public String getBuildNumber() {
        return "6096";
    }

    @Override
    public String getShortDescription() {
        return "Convert worklog username references to lowercase so that they can be used as keys";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.doWorklogUpgrade();
    }

    @Override
    protected Map<String, String> toUsernameMap(SelectQuery<String> selectQuery) {
        Map<String, String> map = super.toUsernameMap(selectQuery);
        Matcher matcher = REGEX_RECYCLED_USED.matcher("");
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            if (!matcher.reset(iter.next()).matches()) continue;
            iter.remove();
        }
        return map;
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6085";
    }
}

