/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6129
extends LegacyImmediateUpgradeTask {
    public static final String ISSUE_ENTITY_NAME = "Issue";
    public static final String ISSUE_TABLE_NAME = "jiraissue";
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6129.class);

    @Override
    public String getBuildNumber() {
        return "6129";
    }

    @Override
    public String getShortDescription() {
        return "Extract Issue number to a separate column";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        DateTime startedAt = new DateTime();
        Connection connection = this.getDatabaseConnection();
        try {
            connection.setAutoCommit(false);
            if (this.isPostgreSQL()) {
                this.postgresUpgrade(connection);
            } else if (this.isMYSQL()) {
                this.mysqlUpgrade(connection);
            } else if (this.isORACLE()) {
                this.oracleUpgrade(connection);
            } else if (this.isMSSQL()) {
                this.msSqlUpgrade(connection);
            }
            this.genericUpgrade(connection);
        }
        catch (Throwable throwable) {
            log.info(String.format("Upgrade task took %d seconds to complete", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds()));
            connection.close();
            throw throwable;
        }
        log.info(String.format("Upgrade task took %d seconds to complete", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds()));
        connection.close();
    }

    private void msSqlUpgrade(Connection connection) throws SQLException, GenericEntityException {
        this.substrUpgrade(connection, new MsSqlSubstringBuilder(), "NUMERIC");
    }

    private void oracleUpgrade(Connection connection) throws SQLException, GenericEntityException {
        this.substrUpgrade(connection, new NormalSqlSubstringBuilder(), "NUMBER");
    }

    private Map<String, Long> getAllProjects() {
        return Select.columns("id", "key").from("Project").runWith(UpgradeTask_Build6129.getEntityEngine()).consumeWith(new ProjectConsumer());
    }

    private void postgresUpgrade(Connection connection) throws SQLException, GenericEntityException {
        this.substrUpgrade(connection, new NormalSqlSubstringBuilder(), "INT");
    }

    private void mysqlUpgrade(Connection connection) throws SQLException, GenericEntityException {
        this.substrUpgrade(connection, new NormalSqlSubstringBuilder(), "UNSIGNED");
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Non-constant but safe.")
    private void substrUpgrade(Connection connection, SqlSubstringBuilder substr, String castType) throws SQLException, GenericEntityException {
        ModelEntity issueTable = UpgradeTask_Build6129.getOfBizDelegator().getModelReader().getModelEntity(ISSUE_ENTITY_NAME);
        String projectColumn = issueTable.getField("project").getColName();
        String issueNumColumn = issueTable.getField("number").getColName();
        String keyColumn = issueTable.getField("key").getColName();
        Statement statement = connection.createStatement();
        for (Map.Entry<String, Long> entry : this.getAllProjects().entrySet()) {
            String projectKey = entry.getKey();
            Long projectId = entry.getValue();
            try {
                int index = projectKey.length() + 2;
                String update = "UPDATE " + this.convertToSchemaTableName(ISSUE_TABLE_NAME) + " SET " + issueNumColumn + "=CAST(" + substr.of(keyColumn, index) + " AS " + castType + "), " + keyColumn + "=NULL" + " WHERE " + projectColumn + '=' + projectId + " AND " + keyColumn + " IS NOT NULL";
                int updated = statement.executeUpdate(update);
                connection.commit();
                if (updated <= 0) continue;
                log.info("[" + projectKey + "] issues updated: " + updated);
            }
            catch (SQLException sqle) {
                log.warn("[" + projectKey + "] fast upgrade failed (will fall back on slow upgrade): " + sqle);
                connection.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="Non-constant but safe.")
    private void genericUpgrade(Connection connection) throws Exception {
        try {
            long issuesInTotal = this.getIssueCount();
            log.info("Total issue count: " + issuesInTotal);
            ModelEntity issueTable = UpgradeTask_Build6129.getOfBizDelegator().getModelReader().getModelEntity(ISSUE_ENTITY_NAME);
            String issueNumColumn = issueTable.getField("number").getColName();
            String keyColumn = issueTable.getField("key").getColName();
            String idColumn = issueTable.getField("id").getColName();
            String selectSql = "SELECT " + idColumn + ", " + keyColumn + " FROM " + this.convertToSchemaTableName(ISSUE_TABLE_NAME) + " WHERE " + keyColumn + " IS NOT NULL ";
            try (PreparedStatement selectStmt = connection.prepareStatement(selectSql);){
                String updateSql = "UPDATE " + this.convertToSchemaTableName(ISSUE_TABLE_NAME) + " SET " + issueNumColumn + "= ? WHERE " + idColumn + "= ? ";
                try (PreparedStatement updateStmt = connection.prepareStatement(updateSql);){
                    try (ResultSet rs = selectStmt.executeQuery();){
                        this.genericUpgradeBatch(connection, issuesInTotal, updateStmt, rs);
                    }
                    updateStmt.executeBatch();
                }
            }
            connection.commit();
        }
        catch (Exception e) {
            connection.rollback();
            throw e;
        }
    }

    private void genericUpgradeBatch(Connection connection, long issuesInTotal, PreparedStatement updateStmt, ResultSet rs) throws SQLException {
        DateTime lastReport = new DateTime();
        long processed = 0L;
        while (rs.next()) {
            String pkey = null;
            long issueNum = -1L;
            long id = -1L;
            try {
                DateTime now;
                pkey = rs.getString("pkey");
                id = rs.getLong("id");
                issueNum = this.getIssueNumberFromKey(pkey);
                updateStmt.setLong(1, issueNum);
                updateStmt.setLong(2, id);
                updateStmt.addBatch();
                if (++processed % 250L == 0L) {
                    updateStmt.executeBatch();
                    connection.commit();
                }
                if (!Seconds.secondsBetween((ReadableInstant)lastReport, (ReadableInstant)(now = new DateTime())).isGreaterThan(Seconds.seconds((int)30))) continue;
                lastReport = now;
                log.info(String.format("Processed %d Issues, %d left for processing", processed, issuesInTotal - processed));
            }
            catch (SQLException sqle) {
                log.error("Update failed in batch.  Detected at processed=" + processed + "; pkey=" + pkey + "; issueNum=" + issueNum + "; id=" + id + "; sqle=" + sqle);
                for (SQLException ex = sqle.getNextException(); ex != null; ex = ex.getNextException()) {
                    log.error("Chained exception: " + ex);
                }
                throw sqle;
            }
        }
        log.info("Total issues handled row-at-a-time: " + processed);
    }

    protected long getIssueCount() {
        return (Long)Select.countFrom(ISSUE_ENTITY_NAME).runWith(UpgradeTask_Build6129.getOfBizDelegator()).singleValue();
    }

    protected long getIssueNumberFromKey(String pkey) {
        return IssueKey.from((String)pkey).getIssueNumber();
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6128";
    }

    static class ProjectConsumer
    implements EntityListConsumer<GenericValue, Map<String, Long>> {
        final Map<String, Long> result = new TreeMap<String, Long>();

        ProjectConsumer() {
        }

        @Override
        public void consume(GenericValue gv) {
            this.result.put(gv.getString("key"), gv.getLong("id"));
        }

        @Override
        public Map<String, Long> result() {
            return this.result;
        }
    }

    static class MsSqlSubstringBuilder
    implements SqlSubstringBuilder {
        MsSqlSubstringBuilder() {
        }

        @Override
        public String of(String column, int index) {
            return "SUBSTRING(" + column + ',' + index + ",999)";
        }
    }

    static class NormalSqlSubstringBuilder
    implements SqlSubstringBuilder {
        NormalSqlSubstringBuilder() {
        }

        @Override
        public String of(String column, int index) {
            return "SUBSTR(" + column + ',' + index + ')';
        }
    }

    static interface SqlSubstringBuilder {
        public String of(String var1, int var2);
    }
}

