/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build64003
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build64003.class);
    private final OfBizDelegator ofBizDelegator;

    public UpgradeTask_Build64003(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public String getBuildNumber() {
        return "64003";
    }

    @Override
    public String getShortDescription() {
        return "JRA-33781: IllegalArgumentException: No event type with id 17";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (setupMode) {
            return;
        }
        if (Select.from("EventType").byId(EventType.ISSUE_COMMENT_DELETED_ID).runWith(this.ofBizDelegator).count() > 0L) {
            log.info("EventType with id " + EventType.ISSUE_COMMENT_DELETED_ID + " already present in DB.");
            return;
        }
        HashMap values = Maps.newHashMap();
        values.put("id", EventType.ISSUE_COMMENT_DELETED_ID);
        values.put("name", "Issue Comment Deleted");
        values.put("description", "This is the 'issue comment deleted' event.");
        values.put("type", "jira.system.event.type");
        this.ofBizDelegator.createValue("EventType", (Map)values);
        log.info("Upgrade task finished");
    }
}

