/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build752
extends LegacyImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTask_Build752.class);
    private final OfBizDelegator delegator;

    public UpgradeTask_Build752(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "752";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        List pages = this.delegator.findAll("PortalPage");
        if (pages != null) {
            LOG.info(String.format("Analysing %d Portal Pages...", pages.size()));
            for (GenericValue gv : pages) {
                String lowercase_username;
                String username = gv.getString("username");
                if (!StringUtils.isNotEmpty((String)username) || username.equals(lowercase_username = IdentifierUtils.toLowerCase((String)username))) continue;
                gv.setString("username", lowercase_username);
                this.delegator.store(gv);
            }
        }
    }

    @Override
    public String getShortDescription() {
        return "Make the owner of a dashboard lowercase";
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "751";
    }

    private static final class Column {
        public static final String USERNAME = "username";

        private Column() {
        }
    }

    private static final class Table {
        public static final String NAME = "PortalPage";

        private Table() {
        }
    }
}

