/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.util;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.scheduler.caesium.cron.parser.CronExpressionParser;
import com.atlassian.scheduler.cron.CronSyntaxException;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CronExpressionFixer {
    private static final int MAX_ATTEMPTS = 5;
    private final String originalCronExpression;
    private final CronSyntaxException originalException;
    private String cronExpression;
    private CronSyntaxException exception;

    @Nonnull
    public static Result repairCronExpression(String cronExpression) {
        Assertions.notNull((String)"cronExpression", (Object)cronExpression);
        CronSyntaxException exception = CronExpressionFixer.findNextSyntaxError(cronExpression);
        if (exception == null) {
            return Result.ALREADY_VALID;
        }
        return new CronExpressionFixer(cronExpression, exception).repair();
    }

    private CronExpressionFixer(@Nonnull String originalCronExpression, @Nonnull CronSyntaxException originalException) {
        this.originalCronExpression = originalCronExpression;
        this.originalException = originalException;
    }

    private Result repair() {
        this.cronExpression = this.originalCronExpression;
        this.exception = this.originalException;
        for (int attempt = 1; attempt <= 5 && this.tryRepair(); ++attempt) {
            this.exception = CronExpressionFixer.findNextSyntaxError(this.cronExpression);
            if (this.exception != null) continue;
            return Result.success(this.cronExpression);
        }
        return Result.failure(this.originalException);
    }

    private boolean tryRepair() {
        switch (this.exception.getErrorCode()) {
            case INVALID_STEP: 
            case INVALID_STEP_SECOND_OR_MINUTE: 
            case INVALID_STEP_HOUR: 
            case INVALID_STEP_DAY_OF_MONTH: 
            case INVALID_STEP_MONTH: 
            case INVALID_STEP_DAY_OF_WEEK: {
                return this.discardInvalidStep(this.exception.getErrorOffset() - 1);
            }
            case COMMA_WITH_WEEKDAY_DOM: 
            case UNEXPECTED_TOKEN_FLAG_W: {
                return this.discardWeekdayFlags(this.exception.getErrorOffset());
            }
            case ILLEGAL_CHARACTER: 
            case ILLEGAL_CHARACTER_AFTER_HASH: 
            case ILLEGAL_CHARACTER_AFTER_INTERVAL: 
            case ILLEGAL_CHARACTER_AFTER_QM: {
                return this.discardIllegalCharacter(this.exception.getErrorOffset());
            }
        }
        return false;
    }

    private boolean discardInvalidStep(int offset) {
        if (this.isOutOfBounds(offset) || this.cronExpression.charAt(offset) != '/') {
            return false;
        }
        this.deleteSubstring(offset, this.searchForwardForEndOfField(offset));
        return true;
    }

    private boolean discardWeekdayFlags(int offset) {
        if (this.isOutOfBounds(offset)) {
            return false;
        }
        int start = this.searchBackwardForStartOfField(offset);
        int stop = this.searchForwardForEndOfField(offset);
        StringBuilder sb = new StringBuilder(this.cronExpression);
        for (int i = start; i < stop; ++i) {
            char c = sb.charAt(i);
            if (c != 'w' && c != 'W') continue;
            sb.deleteCharAt(i);
            --i;
            --stop;
        }
        this.cronExpression = sb.toString();
        return true;
    }

    private boolean discardIllegalCharacter(int offset) {
        if (this.isOutOfBounds(offset)) {
            return false;
        }
        this.deleteSubstring(offset, offset + 1);
        return true;
    }

    private void deleteSubstring(int offset, int stop) {
        StringBuilder sb = new StringBuilder(this.cronExpression.length());
        sb.append(this.cronExpression, 0, offset);
        if (stop < this.cronExpression.length()) {
            sb.append(this.cronExpression, stop, this.cronExpression.length());
        }
        this.cronExpression = sb.toString();
    }

    private int searchBackwardForStartOfField(int offset) {
        int start;
        for (start = offset - 1; start >= 0 && !CronExpressionFixer.isSpace(this.cronExpression.charAt(start)); --start) {
        }
        return start + 1;
    }

    private int searchForwardForEndOfField(int offset) {
        int stop;
        for (stop = offset + 1; stop < this.cronExpression.length() && !CronExpressionFixer.isSpace(this.cronExpression.charAt(stop)); ++stop) {
        }
        return stop;
    }

    private boolean isOutOfBounds(int offset) {
        return offset < 0 || offset >= this.cronExpression.length();
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private static CronSyntaxException findNextSyntaxError(String cronExpression) {
        try {
            CronExpressionParser.parse((String)cronExpression);
            return null;
        }
        catch (CronSyntaxException cse) {
            return cse;
        }
    }

    public static class Result {
        static final Result ALREADY_VALID = new Result(Optional.empty(), Optional.empty());
        private final Optional<String> newCronExpression;
        private final Optional<CronSyntaxException> exception;

        private Result(Optional<String> newCronExpression, Optional<CronSyntaxException> exception) {
            this.newCronExpression = newCronExpression;
            this.exception = exception;
        }

        public Optional<CronSyntaxException> getCronSyntaxException() {
            return this.exception;
        }

        public Optional<String> getNewCronExpression() {
            return this.newCronExpression;
        }

        static Result success(String newCronExpression) {
            return new Result(Optional.of(newCronExpression), Optional.empty());
        }

        static Result failure(CronSyntaxException exception) {
            return new Result(Optional.empty(), Optional.of(exception));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Result && this.equals((Result)o);
        }

        private boolean equals(@Nonnull Result other) {
            return this.newCronExpression.equals(other.newCronExpression) && this.exception.equals(other.exception);
        }

        public int hashCode() {
            return 31 * this.newCronExpression.hashCode() + this.exception.hashCode();
        }

        public String toString() {
            return "Result[newCronExpression=" + this.newCronExpression + ", exception=" + this.exception + ']';
        }
    }
}

