/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SneakyAutoLoginUtil {
    private static final Logger log = LoggerFactory.getLogger(SneakyAutoLoginUtil.class);

    @Nullable
    public static ApplicationUser logUserInByName(String username, HttpServletRequest request) {
        UserManager userManager = ComponentAccessor.getUserManager();
        ApplicationUser user = userManager.getUserByName(username);
        boolean autoLoginWorked = SneakyAutoLoginUtil.logUserIn(user, request);
        if (!autoLoginWorked) {
            return null;
        }
        try {
            LoginStore loginStore = (LoginStore)ComponentAccessor.getComponent(LoginStore.class);
            Long loginCount = loginStore.getLoginInfo(user).getLoginCount();
            if (loginCount == null || loginCount == 0L) {
                loginStore.recordLoginAttempt(user, true);
            }
        }
        catch (Exception e) {
            log.error("Could not record the login attempt for user '" + username + "'.", (Throwable)e);
        }
        return user;
    }

    public static boolean logUserIn(String username, HttpServletRequest request) {
        return SneakyAutoLoginUtil.logUserInByName(username, request) == null;
    }

    public static boolean logUserIn(ApplicationUser user, HttpServletRequest request) {
        if (user == null) {
            log.warn("Unable to automatically log in: user is null");
        } else {
            try {
                CrowdService crowdService = ComponentAccessor.getCrowdService();
                if (crowdService != null) {
                    ApplicationUser principal = ComponentAccessor.getUserManager().getUserByName(user.getName());
                    request.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)principal);
                    request.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
                    InternalWebSudoManager webSudoManager = (InternalWebSudoManager)ComponentAccessor.getComponent(InternalWebSudoManager.class);
                    webSudoManager.markWebSudoRequest(request);
                    return true;
                }
                log.warn("Unable to automatically log in: crowdService is null");
            }
            catch (Exception e) {
                log.warn("Error with automatic log in. The user will need to log in manually.", (Throwable)e);
            }
        }
        return false;
    }
}

