/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.util.Stack;

public class ClassNameAbbreviator {
    public static final ClassNameAbbreviator DEFAULT = new ClassNameAbbreviator(5);
    private final int minChunks;

    public ClassNameAbbreviator(int minChunks) {
        this.minChunks = minChunks;
    }

    public String getAbbreviatedName(String name) {
        if (name == null || name.length() <= 2) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        Stack<Integer> chunkStart = new Stack<Integer>();
        chunkStart.push(0);
        int pos = 0;
        int leadingDot = 0;
        if (name.charAt(pos) == '.') {
            buf.append(name.charAt(pos));
            ++pos;
            leadingDot = 1;
        }
        block0: while (pos < name.length()) {
            if (Character.isUpperCase(name.charAt(pos))) {
                return buf.append(name, pos, name.length()).toString();
            }
            buf.append(name.charAt(pos));
            ++pos;
            while (pos < name.length()) {
                if (name.charAt(pos) == '.') {
                    buf.append(name.charAt(pos));
                    chunkStart.push(pos);
                    ++pos;
                    continue block0;
                }
                ++pos;
            }
        }
        int totalChunks = chunkStart.size();
        int wordsToCompress = Math.max(0, totalChunks - this.minChunks);
        int remainingChunks = Math.min(totalChunks, this.minChunks);
        String prefix = "";
        if (wordsToCompress > 0) {
            int end = Math.min(2 * wordsToCompress - 1 + leadingDot, buf.length());
            prefix = buf.substring(0, end);
        }
        if (remainingChunks == 0) {
            return prefix;
        }
        int suffixStart = 0;
        for (int i = 0; i < remainingChunks; ++i) {
            suffixStart = (Integer)chunkStart.pop();
        }
        return prefix + name.substring(suffixStart);
    }
}

