/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneDirectoryUtilsImpl
implements LuceneDirectoryUtils {
    private static final Logger log = LoggerFactory.getLogger(LuceneDirectoryUtilsImpl.class);
    private static final String LOCK_FILENAME_PREFIX = "Lock@";

    @Override
    public Directory getDirectory(File path) {
        try {
            return FSDirectory.open((File)path, (LockFactory)new UtilConcurrentLockFactory());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void createDirRobust(String path) throws IOException {
        File potentialPath = new File(path);
        if (!potentialPath.exists()) {
            log.warn("Directory " + path + " does not exist - perhaps it was deleted?  Creating..");
            boolean created = potentialPath.mkdirs();
            if (!created) {
                log.warn("Directory " + path + " could not be created.  Aborting index creation");
                throw new IOException("Could not create directory: " + path);
            }
        }
        if (!potentialPath.isDirectory()) {
            log.warn("File " + path + " is not a directory.  Cannot create index");
            throw new IOException("File " + path + " is not a directory.  Cannot create index");
        }
        if (!potentialPath.canWrite()) {
            log.warn("Dir " + path + " is not writable.  Cannot create index");
            throw new IOException("Dir " + path + " is not writable.  Cannot create index");
        }
    }

    @Override
    public Collection<String> getStaleLockPaths(Collection<String> indexDirectoryPaths) {
        ArrayList existingLockFilepaths = Lists.newArrayList();
        try {
            if (indexDirectoryPaths != null) {
                for (String indexDirectoryPath : indexDirectoryPaths) {
                    existingLockFilepaths.addAll(this.getLocks(indexDirectoryPath));
                }
            }
        }
        catch (IOException e) {
            log.error("While trying to check for stale lock files: " + e.getMessage());
        }
        return existingLockFilepaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getLocks(String path) throws IOException {
        ArrayList locks = Lists.newArrayList();
        try (Directory dir = null;){
            dir = this.getDirectory(new File(path));
            Lock lock = dir.makeLock("write.lock");
            if (lock.isLocked()) {
                locks.add(LuceneDirectoryUtilsImpl.getLockFilepath(lock));
            }
        }
        return locks;
    }

    private static String getLockFilepath(Lock lock) {
        if (lock == null) {
            return "";
        }
        String filePath = lock.toString();
        if (filePath != null && filePath.startsWith(LOCK_FILENAME_PREFIX)) {
            filePath = filePath.substring(LOCK_FILENAME_PREFIX.length());
        }
        return filePath;
    }

    static final class UtilConcurrentLock
    extends Lock {
        private final ReentrantLock lock = new ReentrantLock();

        UtilConcurrentLock() {
        }

        public boolean isLocked() {
            return this.lock.isLocked();
        }

        public boolean obtain() {
            return this.lock.tryLock();
        }

        public void release() {
            this.lock.unlock();
        }

        public boolean obtain(long timeout) throws LockObtainFailedException {
            try {
                return this.lock.tryLock(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new LockObtainFailedException(e.toString());
            }
        }
    }

    static final class UtilConcurrentLockFactory
    extends LockFactory {
        private final ConcurrentMap<String, UtilConcurrentLock> map = CopyOnWriteMap.newHashMap();

        UtilConcurrentLockFactory() {
        }

        public void clearLock(String lockName) throws IOException {
            this.map.remove(lockName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lock makeLock(String lockName) {
            UtilConcurrentLock result = new UtilConcurrentLock();
            try {
                UtilConcurrentLock utilConcurrentLock = result;
                return utilConcurrentLock;
            }
            finally {
                this.map.put(lockName, result);
            }
        }
    }
}

