/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.JiraProductInformation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileBackedJiraProductInformation
implements JiraProductInformation {
    private static final String PROPERTIES_FILE_NAME = "/product.properties";
    private static final Logger log = LoggerFactory.getLogger(PropertiesFileBackedJiraProductInformation.class);
    private final Properties properties = new Properties();

    public PropertiesFileBackedJiraProductInformation() {
        this(PropertiesFileBackedJiraProductInformation.loadFromPropertiesFile());
    }

    public PropertiesFileBackedJiraProductInformation(Properties values) {
        if (values != null) {
            this.properties.putAll((Map<?, ?>)values);
        }
    }

    private static Properties loadFromPropertiesFile() {
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader(PropertiesFileBackedJiraProductInformation.class.getResourceAsStream(PROPERTIES_FILE_NAME));){
            properties.load(reader);
        }
        catch (IOException e) {
            log.warn("Could not read product information.", (Throwable)e);
        }
        return properties;
    }

    @Override
    public String getValueForKey(JiraProductInformation.Keys key) {
        String value = (String)this.properties.get(key.getKey());
        return value != null ? value : key.getDefaultValue();
    }
}

