/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation.cache;

import java.util.Objects;
import javax.annotation.Nonnull;

public class CacheDisplayBean {
    private String name;
    private String cacheType;
    private long hitCount;
    private long missCount;
    private long loads;
    private double avgLoadTime;
    private long size;
    private long putCount;

    public CacheDisplayBean(@Nonnull String name, @Nonnull String type) {
        this.name = Objects.requireNonNull(name);
        this.cacheType = Objects.requireNonNull(type);
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return CacheDisplayBean.shorten(this.name);
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public double getAvgLoadTime() {
        return this.avgLoadTime;
    }

    public long getLoads() {
        return this.loads;
    }

    public void setLoads(long loads) {
        this.loads = loads;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCacheType(String cacheType) {
        this.cacheType = cacheType;
    }

    public void setHitCount(long hitCount) {
        this.hitCount = hitCount;
    }

    public void setMissCount(long missCount) {
        this.missCount = missCount;
    }

    public void setAvgLoadTime(double avgLoadTime) {
        this.avgLoadTime = avgLoadTime;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public long getPutCount() {
        return this.putCount;
    }

    public void setPutCount(long count) {
        this.putCount = count;
    }

    private static String shorten(String name) {
        String[] splits = name.split("\\.");
        if (splits.length > 2) {
            return splits[splits.length - 2] + "." + splits[splits.length - 1];
        }
        return name;
    }

    protected static CacheDisplayBean add(@Nonnull CacheDisplayBean arg1, @Nonnull CacheDisplayBean arg2) {
        Objects.requireNonNull(arg1);
        Objects.requireNonNull(arg2);
        CacheDisplayBean result = new CacheDisplayBean(arg1.name, arg1.cacheType);
        result.setHitCount(arg1.hitCount + arg2.hitCount);
        result.setMissCount(arg1.missCount + arg2.missCount);
        result.setPutCount(arg1.putCount + arg2.putCount);
        result.setLoads(arg1.loads + arg2.loads);
        result.setAvgLoadTime(arg1.avgLoadTime + arg2.avgLoadTime);
        result.setSize(arg1.size);
        return result;
    }
}

