/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation.cache;

import com.atlassian.instrumentation.caches.CacheKeys;
import com.atlassian.jira.instrumentation.CacheStatistics;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CacheStatsAverager {
    private String name;
    private long hits;
    private long puts;
    private long misses;
    private long removes;
    private long loads;
    private double loadTime;
    private long total = 0L;
    private long count = 1L;

    public CacheStatsAverager(@Nonnull String name, long hits, long puts, long misses, long remove, long loads, double loadTime) {
        this.name = Objects.requireNonNull(name);
        this.hits = hits;
        this.puts = puts;
        this.misses = misses;
        this.removes = remove;
        this.loads = loads;
        this.loadTime = loadTime;
    }

    public static CacheStatsAverager build(@Nonnull String name, @Nonnull CacheStatistics stats) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(stats, "stats");
        return new CacheStatsAverager(name, (Long)stats.getStatsMap().getOrDefault(CacheKeys.HITS.getName(), 0L), (Long)stats.getStatsMap().getOrDefault(CacheKeys.PUTS.getName(), 0L), (Long)stats.getStatsMap().getOrDefault(CacheKeys.MISSES.getName(), 0L), (Long)stats.getStatsMap().getOrDefault(CacheKeys.REMOVES.getName(), 0L), (Long)stats.getStatsMap().getOrDefault(CacheKeys.LOADS.getName(), 0L), (Double)stats.getStatsMap().getOrDefault(CacheKeys.LOAD_TIME.getName(), 0.0));
    }

    public CacheStatsAverager addAndSetCount(CacheStatsAverager b, long count) {
        CacheStatsAverager result = new CacheStatsAverager(this.getName(), this.getHits() + b.getHits(), this.getPuts() + b.getPuts(), this.getMisses() + b.getMisses(), this.getRemoves() + b.getRemoves(), this.getLoads() + b.getLoads(), this.getLoadTime() + b.getLoadTime());
        result.setCount(count);
        return result;
    }

    public double getAverageHits() {
        if (this.count != 0L) {
            return (double)this.hits / (double)this.count;
        }
        return 0.0;
    }

    public double getAveragePuts() {
        if (this.count != 0L) {
            return (double)this.puts / (double)this.count;
        }
        return 0.0;
    }

    public double getAverageMisses() {
        if (this.count != 0L) {
            return (double)this.misses / (double)this.count;
        }
        return 0.0;
    }

    public double getAverageRemoves() {
        if (this.count != 0L) {
            return (double)this.removes / (double)this.count;
        }
        return 0.0;
    }

    public double getAverageLoadTime() {
        if (this.misses != 0L) {
            return this.loadTime / (double)this.misses;
        }
        return 0.0;
    }

    public double getAverageLoads() {
        if (this.count != 0L) {
            return (double)this.loads / (double)this.count;
        }
        return 0.0;
    }

    public double getHitRate() {
        if (this.getMisses() + this.getHits() == 0L) {
            return 0.0;
        }
        return (double)this.getHits() / (double)(this.getHits() + this.getMisses()) * 100.0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = Objects.requireNonNull(name);
    }

    public long getHits() {
        return this.hits;
    }

    public void setHits(long hits) {
        this.hits = hits;
    }

    public long getPuts() {
        return this.puts;
    }

    public void setPuts(long puts) {
        this.puts = puts;
    }

    public long getMisses() {
        return this.misses;
    }

    public void setMisses(long misses) {
        this.misses = misses;
    }

    public long getRemoves() {
        return this.removes;
    }

    public void setRemoves(long removes) {
        this.removes = removes;
    }

    public long getLoads() {
        return this.loads;
    }

    public double getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(double loadTime) {
        this.loadTime = loadTime;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }
}

