/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class AbstractFieldScreenSchemeAction
extends JiraWebActionSupport {
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private String fieldScreenSchemeName;
    private String fieldScreenSchemeDescription;
    private Long id;
    private Collection<FieldScreenScheme> fieldScreenSchemes;

    protected AbstractFieldScreenSchemeAction(FieldScreenSchemeManager fieldScreenSchemeManager) {
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
    }

    public String getFieldScreenSchemeName() {
        return this.fieldScreenSchemeName;
    }

    public void setFieldScreenSchemeName(String fieldScreenSchemeName) {
        this.fieldScreenSchemeName = fieldScreenSchemeName;
    }

    public String getFieldScreenSchemeDescription() {
        return this.fieldScreenSchemeDescription;
    }

    public void setFieldScreenSchemeDescription(String fieldScreenSchemeDescription) {
        this.fieldScreenSchemeDescription = fieldScreenSchemeDescription;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Nullable
    public FieldScreenScheme getFieldScreenScheme() {
        return this.fieldScreenSchemeManager.getFieldScreenScheme(this.getId());
    }

    public Collection<FieldScreenScheme> getFieldScreenSchemes() {
        if (this.fieldScreenSchemes == null) {
            this.fieldScreenSchemes = this.getFieldScreenSchemeManager().getFieldScreenSchemes();
        }
        return this.fieldScreenSchemes;
    }

    protected FieldScreenSchemeManager getFieldScreenSchemeManager() {
        return this.fieldScreenSchemeManager;
    }

    protected void validateName(boolean avoidSameScheme) {
        if (!TextUtils.stringSet((String)this.getFieldScreenSchemeName())) {
            this.addError("fieldScreenSchemeName", this.getText("admin.common.errors.validname"));
        } else {
            for (FieldScreenScheme fieldScreenScheme : this.getFieldScreenSchemes()) {
                if (avoidSameScheme && (!avoidSameScheme || this.getId().equals(fieldScreenScheme.getId())) || !this.getFieldScreenSchemeName().equals(fieldScreenScheme.getName())) continue;
                this.addError("fieldScreenSchemeName", this.getText("admin.errors.screens.duplicate.screen.scheme"));
            }
        }
    }

    protected void validateId() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.required"));
        } else if (this.getFieldScreenScheme() == null) {
            this.addErrorMessage(this.getText("admin.errors.screens.inexistent.screen.with.id", this.getId()));
        }
    }

    protected String redirectToView() {
        return this.returnCompleteWithInlineRedirect("ViewFieldScreenSchemes.jspa");
    }
}

