/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;

public class FilterFavouriteWarningContextProvider
implements ContextProvider {
    @VisibleForTesting
    static final String CONTEXT_KEY_FAVOURITE_COUNT = "favouriteCount";
    private final FavouritesService favouritesService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public FilterFavouriteWarningContextProvider(FavouritesService favouritesService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.favouritesService = favouritesService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(Map<String, String> map) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        SearchRequest searchRequest = (SearchRequest)map.get("searchRequest");
        map.put(CONTEXT_KEY_FAVOURITE_COUNT, this.getOtherFavouriteCount(searchRequest));
        return map;
    }

    private long getOtherFavouriteCount(SearchRequest searchRequest) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        boolean isCurrentUsersFavourite = this.favouritesService.isFavourite(user, (SharedEntity)searchRequest);
        return isCurrentUsersFavourite ? (long)(searchRequest.getFavouriteCount().intValue() - 1) : (long)searchRequest.getFavouriteCount().intValue();
    }
}

