/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperationImpl;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.issue.AbstractCommentableAssignableIssue;
import com.atlassian.jira.web.action.issue.util.ScreenTabErrorHelper;
import com.atlassian.jira.web.action.workflow.WorkflowAwareAction;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import webwork.action.ActionContext;

public class CommentAssignIssue
extends AbstractCommentableAssignableIssue
implements OperationContext,
WorkflowAwareAction {
    private static final Set<String> EITHER_CURRENT_OR_FUTURE_STATE_PERMISSIONS = Collections.singleton("ADD_COMMENTS");
    private final IssueWorkflowManager issueWorkflowManager;
    private WorkflowTransitionUtil workflowTransitionUtil;
    private final IssueService issueService;
    private final Map fieldValuesHolder;
    private IssueService.TransitionValidationResult transitionResult;
    private int action;
    private SortedSet<FieldScreenRenderTab> tabsWithErrors;
    private int selectedTab;

    public CommentAssignIssue(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, IssueService issueService, UserUtil userUtil, IssueWorkflowManager issueWorkflowManager) {
        super(subTaskManager, fieldScreenRendererFactory, commentService, userUtil);
        this.issueService = issueService;
        this.issueWorkflowManager = issueWorkflowManager;
        this.fieldValuesHolder = new HashMap();
    }

    protected WorkflowTransitionUtil getWorkflowTransitionUtil() {
        if (this.workflowTransitionUtil == null) {
            this.workflowTransitionUtil = JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
            this.workflowTransitionUtil.setIssue(this.getMutableIssue());
            this.workflowTransitionUtil.setAction(this.getAction());
        }
        return this.workflowTransitionUtil;
    }

    @Override
    public String doDefault() throws Exception {
        try {
            super.doDefault();
        }
        catch (IssueNotFoundException e) {
            return "issue-permission-error";
        }
        catch (IssuePermissionException e) {
            return "issue-permission-error";
        }
        for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                if (!fieldScreenRenderLayoutItem.isShow(this.getIssueObject())) continue;
                fieldScreenRenderLayoutItem.populateFromIssue(this.getFieldValuesHolder(), this.getIssueObject());
            }
        }
        if (this.invalidAction()) {
            return "invalidworkflowaction";
        }
        return "input";
    }

    protected boolean invalidAction() {
        return !this.issueWorkflowManager.isValidAction(this.getIssueObject(), this.action, this.getLoggedInUser());
    }

    protected FieldScreenRenderer getFieldScreenRenderer() {
        return this.getWorkflowTransitionUtil().getFieldScreenRenderer();
    }

    public List getFieldScreenRenderTabs() {
        return this.getFieldScreenRenderer().getFieldScreenRenderTabs();
    }

    public Collection getTabsWithErrors() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.tabsWithErrors;
    }

    private void initTabsWithErrors() {
        this.tabsWithErrors = new TreeSet<FieldScreenRenderTab>();
        this.selectedTab = new ScreenTabErrorHelper().initialiseTabsWithErrors(this.tabsWithErrors, this.getErrors(), this.getFieldScreenRenderer(), ActionContext.getParameters());
    }

    public int getSelectedTab() {
        if (this.tabsWithErrors == null) {
            this.initTabsWithErrors();
        }
        return this.selectedTab;
    }

    @Override
    protected void doValidation() {
        try {
            this.getIssue();
        }
        catch (IssuePermissionException ipe) {
            return;
        }
        catch (IssueNotFoundException infe) {
            return;
        }
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters(ActionContext.getParameters());
        issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(false);
        this.transitionResult = this.issueService.validateTransition(this.getLoggedInUser(), this.getIssueObject().getId(), this.action, issueInputParameters);
        this.setFieldValuesHolder(this.transitionResult.getFieldValuesHolder());
        if (!this.transitionResult.isValid()) {
            this.addErrorCollection(this.transitionResult.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.invalidAction()) {
            return "invalidworkflowaction";
        }
        IssueService.IssueResult transitionResult = this.issueService.transition(this.getLoggedInUser(), this.transitionResult);
        if (!transitionResult.isValid()) {
            this.addErrorCollection(transitionResult.getErrorCollection());
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.redirectToView();
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public String getI18nTextViaMetaAttr(String key, Object defaultValue) {
        Object i18nKey = this.getActionDescriptor().getMetaAttributes().get(key);
        if (i18nKey != null && i18nKey instanceof String) {
            String localizedString = this.getText((String)i18nKey);
            if (!i18nKey.equals(localizedString)) {
                return localizedString;
            }
            this.log.warn((Object)("The i18n key" + i18nKey + " in property '" + key + "' for this transition does not contain a valid i18n key."));
        }
        return defaultValue == null ? "" : defaultValue.toString();
    }

    public ActionDescriptor getActionDescriptor() {
        return this.getWorkflowTransitionUtil().getActionDescriptor();
    }

    public Map getCustomFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    @Override
    public IssueOperation getIssueOperation() {
        return new WorkflowIssueOperationImpl(this.getActionDescriptor());
    }

    public Collection getIgnoreFieldIds() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getWorkflowTransitionDisplayName() {
        return this.getWorkflowTransitionDisplayName(this.getActionDescriptor());
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }

    public boolean hasIssuePermission(String permissionKey, Issue issue) {
        return this.hasIssuePermission(new ProjectPermissionKey(permissionKey), issue);
    }

    public boolean hasIssuePermission(ProjectPermissionKey permissionKey, Issue issue) {
        if (!EITHER_CURRENT_OR_FUTURE_STATE_PERMISSIONS.contains(permissionKey.permissionKey())) {
            return super.hasIssuePermission(permissionKey, issue);
        }
        return this.getPermissionManager().hasPermission(permissionKey, issue, this.getLoggedInUser()) || this.getPermissionManager().hasPermission(permissionKey, issue, this.getLoggedInUser(), this.getActionDescriptor());
    }
}

