/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.servlet.InternalServerErrorHelper;
import com.atlassian.jira.web.util.InternalServerErrorDataSource;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommittedResponseHtmlErrorRecoveryFilter
implements Filter {
    public static final String ENABLE_COMMITTED_RESPONSE_HTML_ERROR_RECOVERY = "ENABLE_COMMITTED_RESPONSE_HTML_ERROR_RECOVERY".toString();
    private static final Logger log = LoggerFactory.getLogger(CommittedResponseHtmlErrorRecoveryFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block2: {
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (IOException | RuntimeException | ServletException e) {
                boolean success = this.attemptToRecoverFromExceptionWhenResponseAlreadyCommitted(servletRequest, servletResponse, (Exception)e);
                if (success) break block2;
                throw e;
            }
        }
    }

    private boolean attemptToRecoverFromExceptionWhenResponseAlreadyCommitted(ServletRequest servletRequest, ServletResponse servletResponse, Exception exception) throws IOException {
        if (Boolean.TRUE.equals(servletRequest.getAttribute(ENABLE_COMMITTED_RESPONSE_HTML_ERROR_RECOVERY)) && servletResponse.isCommitted() && servletRequest instanceof HttpServletRequest) {
            log.error("Exception occurred after HTTP response was already committed: {}", (Object)exception.getMessage());
            log.debug("Here's the stacktrace: ", (Throwable)exception);
            servletRequest.setAttribute(InternalServerErrorDataSource.JAVAX_SERVLET_ERROR_EXCEPTION, (Object)exception);
            servletRequest.setAttribute(InternalServerErrorDataSource.JAVAX_SERVLET_ERROR_MESSAGE, (Object)exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            InternalServerErrorHelper.render500ResponsePage((HttpServletRequest)servletRequest, stringWriter);
            String errorPageHtml = stringWriter.toString();
            ImmutableMap.Builder map = ImmutableMap.builder();
            map.put((Object)"contextPath", (Object)((HttpServletRequest)servletRequest).getContextPath());
            map.put((Object)"errorPageHtml", (Object)errorPageHtml);
            SoyTemplateRenderer renderer = (SoyTemplateRenderer)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
            try {
                renderer.render((Appendable)servletResponse.getWriter(), "jira.webresources:committed-response-html-error-recovery", "JIRA.Templates.errors.Misc.committedResponseHtmlErrorRecovery", (Map)map.build());
            }
            catch (SoyException soyException) {
                log.error("Cannot render soy template", (Throwable)soyException);
            }
            servletResponse.getWriter().close();
            return true;
        }
        return false;
    }
}

