/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.seraph.filter.HttpAuthFilter;
import com.atlassian.seraph.filter.LoginFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JiraLoginFilter
implements Filter {
    private static final String OS_AUTH_TYPE = "os_authType";
    private final Filter seraphLoginFilter;
    private final Filter seraphHttpAuthFilter;

    public JiraLoginFilter() {
        this((Filter)new LoginFilter(), (Filter)new HttpAuthFilter());
    }

    JiraLoginFilter(Filter seraphLoginFilter, Filter seraphHttpAuthFilter) {
        this.seraphLoginFilter = (Filter)Assertions.notNull((String)"seraphLoginFilter", (Object)seraphLoginFilter);
        this.seraphHttpAuthFilter = (Filter)Assertions.notNull((String)"seraphHttpAuthFilter", (Object)seraphHttpAuthFilter);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Filter seraphFilterToRun = this.chooseFilterStrategy(servletRequest);
        seraphFilterToRun.doFilter(servletRequest, servletResponse, filterChain);
    }

    private Filter chooseFilterStrategy(ServletRequest servletRequest) {
        if (this.hasOpenSymphonyParameters(servletRequest)) {
            return this.seraphLoginFilter;
        }
        return this.seraphHttpAuthFilter;
    }

    private boolean hasOpenSymphonyParameters(ServletRequest servletRequest) {
        return servletRequest.getParameter("os_username") != null || servletRequest.getParameter(OS_AUTH_TYPE) != null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.seraphLoginFilter.init(filterConfig);
        this.seraphHttpAuthFilter.init(filterConfig);
    }

    public void destroy() {
        this.seraphLoginFilter.destroy();
        this.seraphHttpAuthFilter.destroy();
    }
}

