/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.sitemesh;

import com.atlassian.annotations.Internal;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.sitemesh.AdminDecoratorSectionLinkItemHelper;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Optional;

@Internal
public class DefaultAdminDecoratorSectionLinkItemHelper
implements AdminDecoratorSectionLinkItemHelper {
    private final Comparator<SimpleLinkSection> weightComparator = (e1, e2) -> Integer.compare(e1.getWeight(), e2.getWeight());
    private static final String APP_MENU_ITEM = "admin_applications_menu";
    private static final String APP_ROOT_SECTION = "admin_applications_section";
    private static final String GENERAL_SECTION = "admin_applications_general_section";
    private static final String FALLBACK_SECTION = "admin_applications_integrations_section";
    private static final String DEFAULT_LANDING_PANE = "admin-hipchat-integration";
    private static final String JIRA_SERVICE_DESK_SECTION = "sd-plugin-admin-section";
    private static final String JIRA_SOFTWARE_SECTION = "jira-software-section";
    private final SimpleLinkManager linkManager;
    private final FeatureManager featureManager;
    private final ApplicationRoleManager applicationRoleManager;

    public DefaultAdminDecoratorSectionLinkItemHelper(SimpleLinkManager linkManager, FeatureManager featureManager, ApplicationRoleManager applicationRoleManager) {
        this.linkManager = linkManager;
        this.featureManager = featureManager;
        this.applicationRoleManager = applicationRoleManager;
    }

    @Override
    public Optional<SimpleLink> findSectionLink(SimpleLinkSection currentSection, ApplicationUser loggedInUser, JiraHelper jiraHelper) {
        if (APP_MENU_ITEM.equals(currentSection.getId()) && this.featureManager.isOnDemand()) {
            return this.getSimpleLink(loggedInUser, jiraHelper);
        }
        return Optional.empty();
    }

    private Optional<SimpleLink> getSimpleLink(ApplicationUser loggedInUser, JiraHelper jiraHelper) {
        boolean softwareAvailable = this.applicationRoleManager.isRoleInstalledAndLicensed(ApplicationKeys.SOFTWARE);
        boolean serviceDeskAvailable = this.applicationRoleManager.isRoleInstalledAndLicensed(ApplicationKeys.SERVICE_DESK);
        ImmutableList eligibleSections = (ImmutableList)this.linkManager.getSectionsForLocation(APP_ROOT_SECTION, loggedInUser, jiraHelper).stream().filter(section -> !GENERAL_SECTION.equals(section.getId())).filter(section -> softwareAvailable || !this.sectionIsSoftware((SimpleLinkSection)section)).filter(section -> serviceDeskAvailable || !this.sectionIsServiceDesk((SimpleLinkSection)section)).collect(CollectorsUtil.toImmutableList());
        Optional<SimpleLinkSection> preferredSection = eligibleSections.stream().filter(section -> !section.getId().equals(FALLBACK_SECTION)).sorted(this.weightComparator).findFirst();
        if (preferredSection.isPresent()) {
            String section2 = "admin_applications_section/" + preferredSection.get().getId();
            return this.linkManager.getLinksForSection(section2, loggedInUser, jiraHelper).stream().sorted(this.weightComparator).findFirst();
        }
        Optional<SimpleLinkSection> fallbackSection = eligibleSections.stream().filter(section -> section.getId().equals(FALLBACK_SECTION)).findFirst();
        if (fallbackSection.isPresent()) {
            String section3 = "admin_applications_section/" + fallbackSection.get().getId();
            return this.linkManager.getLinksForSection(section3, loggedInUser, jiraHelper).stream().filter(simpleLink -> DEFAULT_LANDING_PANE.equals(simpleLink.getId())).findFirst();
        }
        return Optional.empty();
    }

    private boolean sectionIsServiceDesk(SimpleLinkSection section) {
        return this.sectionIs(section, JIRA_SERVICE_DESK_SECTION);
    }

    private boolean sectionIsSoftware(SimpleLinkSection section) {
        return this.sectionIs(section, JIRA_SOFTWARE_SECTION);
    }

    private boolean sectionIs(SimpleLinkSection section, String key) {
        return section.getId().equalsIgnoreCase(key);
    }
}

