/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PreValidatedActionExecutor<E> {
    private final List<Supplier<Option<E>>> validators = Lists.newArrayList();

    public PreValidatedActionExecutor<E> withValidator(Supplier<Option<E>> validator) {
        this.validators.add(validator);
        return this;
    }

    public <T> Either<E, T> executeFailOnFirstError(Supplier<Either<E, T>> supplier) {
        for (Supplier<Option<E>> validator : this.validators) {
            Option errorOption = (Option)validator.get();
            if (!errorOption.isDefined()) continue;
            return Either.left((Object)errorOption.get());
        }
        return (Either)supplier.get();
    }
}

