/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin.export;

import com.atlassian.jira.action.admin.export.AnonymousEntity;
import com.atlassian.jira.action.admin.export.AnonymousGenericValue;
import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.ofbiz.core.entity.GenericValue;

public class AnonymisingEntityXmlWriter
implements EntityXmlWriter {
    private final Collection anonymousEntities;
    public static final Collection<AnonymousEntity> DEFAULT_ANONYMOUS_ENTITIES;

    public AnonymisingEntityXmlWriter(Collection anonymousEntities) {
        this.anonymousEntities = anonymousEntities;
    }

    public AnonymisingEntityXmlWriter() {
        this(DEFAULT_ANONYMOUS_ENTITIES);
    }

    @Override
    public void writeXmlText(GenericValue entity, PrintWriter writer) {
        AnonymousGenericValue anonymisingGV = new AnonymousGenericValue(entity, this.anonymousEntities);
        anonymisingGV.writeXmlText(writer, "");
    }

    static {
        ArrayList<AnonymousEntity> defaultAnonymousEntities = new ArrayList<AnonymousEntity>();
        defaultAnonymousEntities.add(new AnonymousEntity("Action", "body"));
        defaultAnonymousEntities.add(new AnonymousEntity("Issue", "environment"));
        defaultAnonymousEntities.add(new AnonymousEntity("Issue", "summary"));
        defaultAnonymousEntities.add(new AnonymousEntity("NotificationInstance", "email"));
        defaultAnonymousEntities.add(new AnonymousEntity("ChangeItem", "newstring"));
        defaultAnonymousEntities.add(new AnonymousEntity("ChangeItem", "oldstring"));
        defaultAnonymousEntities.add(new AnonymousEntity("FileAttachment", "filename"));
        defaultAnonymousEntities.add(new AnonymousEntity("NotificationScheme", "name"));
        defaultAnonymousEntities.add(new AnonymousEntity("PermissionScheme", "name"));
        defaultAnonymousEntities.add(new AnonymousEntity("Resolution", "name"));
        defaultAnonymousEntities.add(new AnonymousEntity(null, "description"));
        defaultAnonymousEntities.add(new AnonymousEntity("CustomFieldValue", "textvalue"));
        defaultAnonymousEntities.add(new AnonymousEntity("MailServer", "name"));
        defaultAnonymousEntities.add(new AnonymousEntity("MailServer", "servername"));
        defaultAnonymousEntities.add(new AnonymousEntity("MailServer", "username"));
        defaultAnonymousEntities.add(new AnonymousEntity("MailServer", "password"));
        defaultAnonymousEntities.add(new AnonymousEntity("Worklog", "body"));
        DEFAULT_ANONYMOUS_ENTITIES = Collections.unmodifiableCollection(defaultAnonymousEntities);
    }
}

