/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity;

import com.atlassian.jira.appconsistency.integrity.IntegrityCheckManager;
import com.atlassian.jira.appconsistency.integrity.check.Check;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntegrityChecker {
    private final IntegrityCheckManager integrityCheckManager;

    public IntegrityChecker(IntegrityCheckManager integrityCheckManager) {
        this.integrityCheckManager = integrityCheckManager;
    }

    public Map preview(List<Check> checks) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Check check : checks) {
            results.put(check, this.preview(check));
        }
        return results;
    }

    public Map previewWithIds(List<Long> checkIds) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Long checkId : checkIds) {
            Check check = this.integrityCheckManager.getCheck(checkId);
            results.put(check, this.preview(check));
        }
        return results;
    }

    public Map correct(List<Check> checks) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Check check : checks) {
            results.put(check, this.correct(check));
        }
        return results;
    }

    public Map correctWithIds(List<Long> checkIds) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Long checkId : checkIds) {
            Check check = this.integrityCheckManager.getCheck(checkId);
            results.put(check, this.correct(check));
        }
        return results;
    }

    public List preview(Check check) throws IntegrityException {
        return check.preview();
    }

    public List correct(Check check) throws IntegrityException {
        return check.correct();
    }
}

