/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.BaseFilterSubscriptionsCheck;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.issue.subscription.DefaultSubscriptionManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.status.JobDetails;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class FilterSubscriptionsScheduleCheck
extends BaseFilterSubscriptionsCheck {
    private final SchedulerService schedulerService;

    public FilterSubscriptionsScheduleCheck(OfBizDelegator ofBizDelegator, SchedulerService schedulerService, int id) {
        super(ofBizDelegator, id);
        this.schedulerService = schedulerService;
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.desc");
    }

    @Override
    protected void doRealCheck(boolean correct, GenericValue subscription, List<DeleteEntityAmendment> messages) throws IntegrityException {
        JobDetails jobDetails = this.getScheduledJob(subscription);
        if (jobDetails == null) {
            if (correct) {
                messages.add(new DeleteEntityAmendment(0, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.message", subscription.getString("id")), subscription));
            } else {
                messages.add(new DeleteEntityAmendment(2, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.preview", subscription.getString("id")), subscription));
            }
        }
    }

    private JobDetails getScheduledJob(GenericValue subscription) {
        JobId jobId = this.toJobId(subscription.getLong("id"));
        return this.schedulerService.getJobDetails(jobId);
    }

    private JobId toJobId(Long subId) {
        return JobId.of((String)(DefaultSubscriptionManager.SUBSCRIPTION_PREFIX + ":" + subId));
    }
}

