/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowStateCheck
extends CheckImpl<CheckAmendment> {
    public WorkflowStateCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.workflow.state.check.desc");
    }

    @Override
    public List<CheckAmendment> preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List<CheckAmendment> correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List<CheckAmendment> doCheck(boolean correct) throws IntegrityException {
        ArrayList<CheckAmendment> results = new ArrayList<CheckAmendment>();
        try {
            for (GenericValue gvIssue : this.getIssuesWithWorkflowId()) {
                Long workflowId = gvIssue.getLong("workflowId");
                List workflowEntries = this.ofBizDelegator.findByAnd("OSWorkflowEntry", (Map)FieldMap.build((String)"id", (Object)workflowId));
                for (GenericValue workflowEntry : workflowEntries) {
                    String message;
                    if (workflowEntry.getInteger("state") != null && !"0".equals(workflowEntry.getInteger("state").toString())) continue;
                    if (correct) {
                        workflowEntry.set("state", (Object)new Integer(1));
                        workflowEntry.store();
                        message = this.getI18NBean().getText("admin.integrity.check.workflow.state.check.message", gvIssue.getString("key"), workflowEntry.getLong("id").toString());
                        results.add(new CheckAmendment(2, message, "JRA-4241"));
                        continue;
                    }
                    message = this.getI18NBean().getText("admin.integrity.check.workflow.state.check.preview", gvIssue.getString("key"), workflowEntry.getLong("id").toString());
                    results.add(new CheckAmendment(2, message, "JRA-4241"));
                }
            }
        }
        catch (GenericEntityException e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        return results;
    }

    private List<GenericValue> getIssuesWithWorkflowId() {
        LinkedList<GenericValue> issues = new LinkedList<GenericValue>();
        try (OfBizListIterator listIterator = this.ofBizDelegator.findListIteratorByCondition("Issue", null, null, Arrays.asList("workflowId", "project", "number"), null, null);){
            GenericValue issue = listIterator.next();
            while (issue != null) {
                issues.add(issue);
                issue = listIterator.next();
            }
        }
        return issues;
    }
}

