/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseMaintenancePredicate;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationAuthorizationServiceImpl
implements ApplicationAuthorizationService {
    private final ApplicationRoleManager applicationRoleManager;
    private final JiraLicenseManager jiraLicenseManager;
    private final Predicate<LicenseDetails> maintenanceCheck;

    public ApplicationAuthorizationServiceImpl(ApplicationRoleManager applicationRoleManager, JiraLicenseManager jiraLicenseManager, LicenseMaintenancePredicate licenseMaintenancePredicate) {
        this.applicationRoleManager = applicationRoleManager;
        this.jiraLicenseManager = jiraLicenseManager;
        this.maintenanceCheck = licenseMaintenancePredicate;
    }

    public boolean isApplicationInstalledAndLicensed(@Nonnull ApplicationKey key) {
        return this.applicationRoleManager.isRoleInstalledAndLicensed((ApplicationKey)Assertions.notNull((String)"key", (Object)key));
    }

    public boolean isAnyRoleLimitExceeded() {
        return this.applicationRoleManager.isAnyRoleLimitExceededAsync();
    }

    public boolean isExceeded(@Nonnull ApplicationKey key) {
        return this.applicationRoleManager.isRoleLimitExceededAsync((ApplicationKey)Assertions.notNull((String)"key", (Object)key));
    }

    public boolean canUseApplication(@Nullable ApplicationUser user, @Nonnull ApplicationKey key) {
        return this.getAccessErrors(user, key).isEmpty();
    }

    public Set<ApplicationAccess.AccessError> getAccessErrors(@Nullable ApplicationUser user, @Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        Set<ApplicationAccess.AccessError> errors = this.getAccessErrorsExact(user, key);
        if (!errors.isEmpty() && key.equals((Object)ApplicationKeys.CORE)) {
            for (ApplicationKey appKey : this.jiraLicenseManager.getAllLicensedApplicationKeys()) {
                Set<ApplicationAccess.AccessError> otherAppErrors = this.getAccessErrorsExact(user, appKey);
                if (!otherAppErrors.isEmpty()) continue;
                return Collections.unmodifiableSet(otherAppErrors);
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    public boolean hasNoLicensingAccessErrors(@Nonnull ApplicationKey key) {
        return this.getLicensingAccessErrors(key).isEmpty();
    }

    public Set<ApplicationAccess.AccessError> getLicensingAccessErrors(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        Set<ApplicationAccess.AccessError> errors = this.getLicensingExactErrors(key);
        if (!errors.isEmpty() && key.equals((Object)ApplicationKeys.CORE)) {
            for (ApplicationKey appKey : this.jiraLicenseManager.getAllLicensedApplicationKeys()) {
                Set<ApplicationAccess.AccessError> otherAppErrors = this.getLicensingExactErrors(appKey);
                if (!otherAppErrors.isEmpty()) continue;
                return Collections.unmodifiableSet(otherAppErrors);
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    public int getUserCount(@Nonnull ApplicationKey key) {
        return this.applicationRoleManager.getUserCountAsync((ApplicationKey)Assertions.notNull((String)"key", (Object)key));
    }

    private Set<ApplicationAccess.AccessError> getAccessErrorsExact(@Nullable ApplicationUser user, ApplicationKey key) {
        Set<ApplicationAccess.AccessError> errors = this.getLicensingExactErrors(key);
        if (!this.applicationRoleManager.userHasRole(user, key)) {
            errors.add(ApplicationAccess.AccessError.NO_ACCESS);
        }
        return errors;
    }

    private Set<ApplicationAccess.AccessError> getLicensingExactErrors(ApplicationKey key) {
        Option licenseForApplication = this.jiraLicenseManager.getLicense(key);
        if (licenseForApplication.isEmpty()) {
            return EnumSet.of(ApplicationAccess.AccessError.UNLICENSED);
        }
        EnumSet<ApplicationAccess.AccessError> errors = EnumSet.noneOf(ApplicationAccess.AccessError.class);
        LicenseDetails licenseDetails = (LicenseDetails)licenseForApplication.get();
        if (licenseDetails.isExpired()) {
            errors.add(ApplicationAccess.AccessError.EXPIRED);
        }
        if (!this.maintenanceCheck.test(licenseDetails)) {
            errors.add(ApplicationAccess.AccessError.VERSION_MISMATCH);
        }
        if (this.applicationRoleManager.isRoleLimitExceededAsync(key)) {
            errors.add(ApplicationAccess.AccessError.USERS_EXCEEDED);
        }
        return errors;
    }
}

