/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.host.ApplicationConfigurationManager;
import com.atlassian.application.host.events.ApplicationDefinedEvent;
import com.atlassian.application.host.events.ApplicationUndefinedEvent;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisationFinishedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.CachingComponent;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.application.ApplicationConfigurationEvent;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.ApplicationRoleDiff;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.atlassian.jira.application.DefinitionApplicationRole;
import com.atlassian.jira.application.IdApplicationRole;
import com.atlassian.jira.auditing.AffectedApplication;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingService;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.crowd.embedded.JiraEncryptingDirectoryDAO;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizTransactionManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultApplicationRoleManager
implements ApplicationRoleManager,
CachingComponent,
LicenseCountService,
ApplicationConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplicationRoleManager.class);
    private static final String AUDIT_CATEGORY = AuditingCategory.APPLICATIONS.getId();
    private static final String ACTIVE_USERS_COUNT_CACHE_ASYNCHRONOUS_FEATURE_FLAG = "com.atlassian.jira.application.active.users.count.cache.asynchronous";
    private final ApplicationRoleDefinitions definitions;
    private final GroupManager groupManager;
    private final ApplicationRoleStore applicationRoleStore;
    private final JiraLicenseManager licenseManager;
    private final RecoveryMode recoveryMode;
    private final CrowdService crowdService;
    private final EventPublisher eventPublisher;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final InternalMembershipDao internalMembershipDao;
    private final JiraEncryptingDirectoryDAO directoryDao;
    private final ExtendedUserDao ofBizUserDao;
    private final OfBizTransactionManager ofBizTransactionManager;
    private final SynchronisationStatusManager crowdSyncStatusManager;
    private final FeatureManager featureManager;
    @ClusterSafe
    private final Cache<ApplicationKey, Option<ApplicationRole>> appRoleCache;
    @ClusterSafe
    private final Cache<ApplicationKey, Integer> activeUsersCountForLicense;
    private final ThreadPoolExecutor cacheRefreshExecutor;
    private volatile Option<Future<Void>> lastRefresh = Option.none();
    private final CachedReference<Integer> billableUsersCount;

    public DefaultApplicationRoleManager(@Nonnull CacheManager cacheManager, @Nonnull ApplicationRoleStore store, @Nonnull ApplicationRoleDefinitions definitions, @Nonnull GroupManager groupManager, @Nonnull JiraLicenseManager licenseManager, @Nonnull RecoveryMode recoveryMode, @Nonnull CrowdService crowdService, @Nonnull EventPublisher eventPublisher, @Nonnull InternalMembershipDao internalMembershipDao, @Nonnull JiraEncryptingDirectoryDAO directoryDao, @Nonnull ExtendedUserDao ofBizUserDao, @Nonnull OfBizTransactionManager ofBizTransactionManager, @Nonnull SynchronisationStatusManager crowdSyncStatusManager, @Nonnull FeatureManager featureManager, @Nonnull DirectoryInstanceLoader directoryInstanceLoader) {
        Assertions.notNull((String)"cacheManager", (Object)cacheManager);
        this.recoveryMode = (RecoveryMode)Assertions.notNull((String)"recoveryMode", (Object)recoveryMode);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.applicationRoleStore = (ApplicationRoleStore)Assertions.notNull((String)"store", (Object)store);
        this.definitions = (ApplicationRoleDefinitions)Assertions.notNull((String)"definitions", (Object)definitions);
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"licenseManager", (Object)licenseManager);
        this.crowdService = (CrowdService)Assertions.notNull((String)"crowdService", (Object)crowdService);
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.internalMembershipDao = (InternalMembershipDao)Assertions.notNull((String)"internalMembershipDao", (Object)internalMembershipDao);
        this.directoryDao = (JiraEncryptingDirectoryDAO)((Object)Assertions.notNull((String)"directoryDao", (Object)((Object)directoryDao)));
        this.ofBizUserDao = (ExtendedUserDao)Assertions.notNull((String)"ofBizUserDao", (Object)ofBizUserDao);
        this.ofBizTransactionManager = (OfBizTransactionManager)Assertions.notNull((String)"ofBizTransactionManager", (Object)ofBizTransactionManager);
        this.crowdSyncStatusManager = (SynchronisationStatusManager)Assertions.notNull((String)"crowdSyncStatusManager", (Object)crowdSyncStatusManager);
        this.cacheRefreshExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(2), new ThreadFactoryBuilder().setNameFormat("default-application-role-manager-cache-refresh-%d").build(), (currentRunnable, executor) -> {
            log.debug("Queue already full. Skipping cache refresh");
            DelegatingSettableFutureTask currentFutureTask = (DelegatingSettableFutureTask)currentRunnable;
            Future refreshRunnableFromQueue = (Future)executor.getQueue().peek();
            currentFutureTask.setDelegate(refreshRunnableFromQueue != null ? refreshRunnableFromQueue : Futures.immediateFuture(null));
        });
        this.appRoleCache = cacheManager.getCache(DefaultApplicationRoleManager.class.getName() + ".applicationRoleGroups", (CacheLoader)new RoleLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(100).build());
        this.activeUsersCountForLicense = cacheManager.getCache("com.atlassian.jira.application.DefaultApplicationRoleManager.activeUsersCountForLicenseUnflushableCache", key -> (Integer)this.getRole((ApplicationKey)key).map(this::countApplicationUsers).getOrElse((Object)0), new CacheSettingsBuilder().remote().replicateViaCopy().unflushable().build());
        this.billableUsersCount = cacheManager.getCachedReference(this.getClass().getName() + ".billableUsersCount", (Supplier)new BillableUserCountLoader(), new CacheSettingsBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build());
        licenseManager.subscribeToClearCache(Void2 -> this.clearCache());
        this.featureManager = featureManager;
        this.directoryInstanceLoader = directoryInstanceLoader;
    }

    @VisibleForTesting
    protected void waitForActiveUsersCacheLoader() {
        Future future = (Future)this.lastRefresh.getOrNull();
        if (future != null) {
            int timeout = 60;
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                future.get(60L, TimeUnit.SECONDS);
                log.debug("Waiting for active users count cache to be refreshed took {}", (Object)stopwatch);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Exception occurred while waiting for queue synchronization", e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("ActiveUsersCountForLicenseCache refresh took over 60 seconds. This operation takes too long and it may affect JIRA performance and stability. Please see https://confluence.atlassian.com/display/JIRAKB/KB-JRASERVER-64384-docs for details.", e);
            }
        }
    }

    private boolean shouldSynchronizeActiveUsersCountCache() {
        return !this.featureManager.isEnabled(ACTIVE_USERS_COUNT_CACHE_ASYNCHRONOUS_FEATURE_FLAG);
    }

    private void refreshActiveUsersCount() {
        log.debug("Request for refresh active users count cache.");
        DelegatingSettableFutureTask future = new DelegatingSettableFutureTask(JiraThreadLocalUtils.wrap(this::tryRefreshActiveUsersCountForLicense));
        this.lastRefresh = Option.some((Object)future);
        Future headOfQueueFuture = (Future)this.cacheRefreshExecutor.getQueue().peek();
        if (headOfQueueFuture != null) {
            future.setDelegate(headOfQueueFuture);
        } else {
            this.cacheRefreshExecutor.execute(future);
        }
    }

    private void tryRefreshActiveUsersCountForLicense() {
        try {
            this.refreshActiveUsersCountForLicense();
        }
        catch (Exception e) {
            log.error("Error occurred while trying to refresh active users count for license", (Throwable)e);
        }
    }

    private void refreshActiveUsersCountForLicense() {
        Set applicationKeys = this.licenseManager.getAllLicensedApplicationKeys();
        List allNotCoreApplicationKeysToRefresh = (List)applicationKeys.stream().filter(applicationKey -> !ApplicationKeys.CORE.equals(applicationKey)).collect(CollectorsUtil.toImmutableListWithSizeOf((Collection)applicationKeys));
        allNotCoreApplicationKeysToRefresh.forEach(applicationKey -> {
            Option<ApplicationRole> applicationRoleOption = this.getRole((ApplicationKey)applicationKey);
            if (applicationRoleOption.isDefined()) {
                ApplicationRole applicationRole = (ApplicationRole)applicationRoleOption.get();
                int count = this.countApplicationRoleUsers(applicationRole);
                this.activeUsersCountForLicense.put(applicationKey, (Object)count);
            } else {
                this.activeUsersCountForLicense.put(applicationKey, (Object)0);
                log.debug("Can't find application role for applicationKey '{}'", applicationKey);
            }
        });
        if (this.getRole(ApplicationKeys.CORE).isDefined()) {
            int coreUsersCount = this.countCoreUsers();
            this.activeUsersCountForLicense.put((Object)ApplicationKeys.CORE, (Object)coreUsersCount);
        } else {
            log.debug("Can't find application role. Skipping active CORE users cache update.");
        }
    }

    @Nonnull
    public Option<ApplicationRole> getRole(@Nonnull ApplicationKey role) {
        Assertions.notNull((String)"role", (Object)role);
        return (Option)this.appRoleCache.get((Object)role);
    }

    @Nonnull
    public Set<ApplicationRole> getRoles() {
        HashSet roles = Sets.newHashSet();
        for (ApplicationKey appKey : this.licenseManager.getAllLicensedApplicationKeys()) {
            Iterables.addAll((Collection)roles, this.getRole(appKey));
        }
        return Collections.unmodifiableSet(roles);
    }

    @Nonnull
    public Set<ApplicationKey> getDefaultApplicationKeys() {
        return (Set)this.getRoles().stream().filter(ApplicationRole::isSelectedByDefault).map(ApplicationRole::getKey).collect(CollectorsUtil.toImmutableSet());
    }

    public boolean hasAnyRole(@Nullable ApplicationUser user) {
        if (Users.isAnonymous((ApplicationUser)user)) {
            return false;
        }
        return this.getRoles().stream().anyMatch(role -> this.userHasRole(user, (ApplicationRole)role)) || this.recoveryMode.isRecoveryUser(user);
    }

    public boolean userHasRole(@Nullable ApplicationUser user, ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        if (Users.isAnonymous((ApplicationUser)user)) {
            return false;
        }
        Set groups = (Set)this.getRole(key).map(ApplicationRole::getGroups).getOrElse((Object)ImmutableSet.of());
        for (Group appGroup : groups) {
            if (!this.groupManager.isUserInGroup(user, appGroup)) continue;
            return true;
        }
        return false;
    }

    public boolean userOccupiesRole(@Nullable ApplicationUser user, ApplicationKey key) {
        return this.getOccupiedLicenseRolesForUser(user).stream().anyMatch(r -> r.getKey().equals((Object)key));
    }

    public boolean isAnyRoleLimitExceeded() {
        return this.getRoles().stream().anyMatch(role -> this.isRoleLimitExceeded(role.getKey()));
    }

    public boolean isAnyRoleLimitExceededAsync() {
        return this.getRoles().stream().anyMatch(role -> this.isRoleLimitExceededAsync(role.getKey()));
    }

    public boolean isRoleLimitExceeded(@Nonnull ApplicationKey applicationKey) {
        if (!this.hasUnlimitedLicense(applicationKey) && this.shouldSynchronizeActiveUsersCountCache()) {
            this.waitForActiveUsersCacheLoader();
        }
        return this.isRoleLimitExceededCurrentValue(applicationKey);
    }

    public boolean isRoleLimitExceededAsync(@Nonnull ApplicationKey applicationKey) {
        return this.isRoleLimitExceededCurrentValue(applicationKey);
    }

    private boolean isRoleLimitExceededCurrentValue(@Nonnull ApplicationKey applicationKey) {
        int numGrantedSeats = this.getNumberOfSeatsGrantedToRole(applicationKey);
        if (numGrantedSeats == -1) {
            return false;
        }
        return this.getUserCountCurrentValue(applicationKey) > numGrantedSeats;
    }

    public boolean hasExceededAllRoles(@Nonnull ApplicationUser user) {
        Set<ApplicationRole> rolesForUser = this.getRolesForUser((ApplicationUser)Assertions.notNull((Object)user));
        boolean hasAtLeastOneUnlimitedLicense = rolesForUser.stream().map(ApplicationRole::getKey).anyMatch(this::hasUnlimitedLicense);
        if (!hasAtLeastOneUnlimitedLicense && this.shouldSynchronizeActiveUsersCountCache()) {
            this.waitForActiveUsersCacheLoader();
        }
        return rolesForUser.stream().allMatch(role -> this.isRoleLimitExceededCurrentValue(role.getKey()));
    }

    public boolean hasExceededAllRolesAsync(@Nonnull ApplicationUser user) {
        Set<ApplicationRole> rolesForUser = this.getRolesForUser((ApplicationUser)Assertions.notNull((Object)user));
        return rolesForUser.stream().allMatch(role -> this.isRoleLimitExceededCurrentValue(role.getKey()));
    }

    public Set<ApplicationRole> getRolesForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((Object)user);
        return (Set)this.getRoles().stream().filter(role -> this.userHasRole(user, (ApplicationRole)role)).collect(CollectorsUtil.toImmutableSet());
    }

    public Set<ApplicationRole> getOccupiedLicenseRolesForUser(@Nonnull ApplicationUser user) {
        boolean allNonCoreRolesExceeded;
        Assertions.notNull((Object)user);
        Set<ApplicationRole> roles = this.getRolesForUser(user);
        if (roles.size() > 1 && roles.stream().anyMatch(r -> ApplicationKeys.CORE.equals((Object)r.getKey())) && !(allNonCoreRolesExceeded = roles.stream().filter(r -> !ApplicationKeys.CORE.equals((Object)r.getKey())).allMatch(r -> this.isRoleLimitExceeded(r.getKey())))) {
            return (Set)roles.stream().filter(r -> !ApplicationKeys.CORE.equals((Object)r.getKey())).collect(CollectorsUtil.toImmutableSet());
        }
        return roles;
    }

    public Set<ApplicationRole> getRolesForGroup(@Nonnull Group group) {
        Assertions.notNull((String)"group", (Object)group);
        HashSet roles = Sets.newHashSet();
        block0: for (ApplicationRole role : this.getRoles()) {
            for (Group roleGroup : role.getGroups()) {
                if (!roleGroup.equals((Object)group) && !this.crowdService.isGroupMemberOfGroup(group, roleGroup)) continue;
                roles.add(role);
                continue block0;
            }
        }
        return Collections.unmodifiableSet(roles);
    }

    @Nonnull
    public Set<Group> getGroupsForLicensedRoles() {
        return (Set)this.getRoles().stream().map(ApplicationRole::getGroups).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    public void removeGroupFromRoles(@Nonnull Group group) {
        Assertions.notNull((String)"group", (Object)group);
        this.logRemovedGroup(group);
        this.applicationRoleStore.removeGroup(group.getName());
        this.clearCache();
    }

    private void logRemovedGroup(@Nonnull Group group) {
        AuditingService auditingService = (AuditingService)ComponentAccessor.getComponent(AuditingService.class);
        Set<ApplicationRole> roles = this.getRoles();
        for (ApplicationRole role : roles) {
            Set groups = role.getGroups();
            if (!groups.contains(group) || auditingService == null) continue;
            ImmutableList associated = ImmutableList.of((Object)new ChangedValueImpl(group.getName(), "Associated", "Group deleted"));
            auditingService.storeRecord(AUDIT_CATEGORY, "Group was deleted", (AssociatedItem)new AffectedApplication(role), (Iterable)associated, null, null);
        }
    }

    public boolean isRoleInstalledAndLicensed(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return this.definitions.isDefined(key) && this.definitions.isLicensed(key);
    }

    @Nonnull
    public ApplicationRole setRole(@Nonnull ApplicationRole role) {
        this.validateRole((ApplicationRole)Assertions.notNull((String)"role", (Object)role));
        this.logDiffForRole(role);
        ApplicationKey key = role.getKey();
        try {
            this.applicationRoleStore.save(new ApplicationRoleStore.ApplicationRoleData(key, DefaultApplicationRoleManager.groupNames(role.getGroups()), DefaultApplicationRoleManager.groupNames(role.getDefaultGroups()), role.isSelectedByDefault()));
        }
        finally {
            this.clearCacheLine(key);
        }
        return (ApplicationRole)((Option)this.appRoleCache.get((Object)key)).getOrElse(() -> IdApplicationRole.empty(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConfiguration(ApplicationKey key) {
        Option oldRole;
        AuditingService auditingService = (AuditingService)ComponentAccessor.getComponent(AuditingService.class);
        if (auditingService != null && (oldRole = this.definitions.getDefined(key).map(ard -> this.applicationRoleDefinitionToApplicationRole(key, (ApplicationRoleDefinitions.ApplicationRoleDefinition)ard))).isDefined()) {
            ApplicationRole role = (ApplicationRole)oldRole.get();
            auditingService.storeRecord(AUDIT_CATEGORY, "Application configuration cleared.", (AssociatedItem)new AffectedApplication(role), ApplicationRoleDiff.diffRemoved(role).messages(), null, null);
        }
        try {
            this.applicationRoleStore.removeByKey(key);
        }
        finally {
            this.clearCacheLine(key);
            this.eventPublisher.publish((Object)new ApplicationConfigurationEvent((Set)ImmutableSet.of((Object)key)));
        }
    }

    public int getUserCount(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        if (this.shouldSynchronizeActiveUsersCountCache()) {
            this.waitForActiveUsersCacheLoader();
        }
        return this.getUserCountCurrentValue(key);
    }

    public int getUserCountAsync(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return this.getUserCountCurrentValue(key);
    }

    private int getUserCountCurrentValue(@Nonnull ApplicationKey key) {
        int userCount = (Integer)this.getRole(key).fold(() -> 0, role -> (Integer)this.activeUsersCountForLicense.get((Object)key));
        log.trace("getUserCountCurrentValue({}) = {}", (Object)key, (Object)userCount);
        return userCount;
    }

    public int getRemainingSeats(@Nonnull ApplicationKey key) {
        if (!this.hasUnlimitedLicense(key) && this.shouldSynchronizeActiveUsersCountCache()) {
            this.waitForActiveUsersCacheLoader();
        }
        return this.getRemainingSeatsCurrentValue(key);
    }

    public int getRemainingSeatsAsync(@Nonnull ApplicationKey key) {
        return this.getRemainingSeatsCurrentValue(key);
    }

    private boolean hasUnlimitedLicense(@Nonnull ApplicationKey key) {
        return this.getNumberOfSeatsGrantedToRole(key) == -1;
    }

    private int getRemainingSeatsCurrentValue(@Nonnull ApplicationKey key) {
        return (Integer)this.getRole((ApplicationKey)Assertions.notNull((String)"key", (Object)key)).map(applicationRole -> {
            int numberOfSeats = applicationRole.getNumberOfSeats();
            if (numberOfSeats == -1) {
                return -1;
            }
            int activeUsers = this.getUserCountCurrentValue(key);
            return Math.max(numberOfSeats - activeUsers, 0);
        }).getOrElse((Object)0);
    }

    public boolean hasSeatsAvailable(@Nonnull ApplicationKey key, int seatCount) {
        if (!this.hasUnlimitedLicense(key) && this.shouldSynchronizeActiveUsersCountCache()) {
            this.waitForActiveUsersCacheLoader();
        }
        return this.hasSeatsAvailableCurrentValue(key, seatCount);
    }

    public boolean hasSeatsAvailableAsync(@Nonnull ApplicationKey key, int seatCount) {
        return this.hasSeatsAvailableCurrentValue(key, seatCount);
    }

    private boolean hasSeatsAvailableCurrentValue(@Nonnull ApplicationKey key, int seatCount) {
        Assertions.notNull((String)"key", (Object)key);
        if (seatCount < 0) {
            throw new IllegalArgumentException("seatCount < 0");
        }
        int remainingSeats = this.getRemainingSeatsCurrentValue(key);
        return remainingSeats == -1 || seatCount <= remainingSeats;
    }

    @Nonnull
    public Set<Group> getDefaultGroups(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return (Set)this.getRole(key).map(ApplicationRole::getDefaultGroups).getOrElse((Object)ImmutableSet.of());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches(event);
        this.eventPublisher.publish((Object)new XMLRestoreFinishedEvent((Object)this, null));
    }

    @EventListener
    public void onApplicationDefined(ApplicationDefinedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onApplicationUndefined(ApplicationUndefinedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onGroupCreated(GroupCreatedEvent createdEvent) {
        if (this.shouldRepopulateCache((DirectoryEvent)createdEvent)) {
            this.clearCaches(createdEvent);
        }
    }

    @EventListener
    public void onGroupDeleted(GroupDeletedEvent deletedEvent) {
        if (this.shouldRepopulateCache((DirectoryEvent)deletedEvent)) {
            this.clearCaches(deletedEvent);
        }
    }

    @EventListener
    public void onGroupUpdated(GroupUpdatedEvent updatedEvent) {
        if (this.shouldRepopulateCache((DirectoryEvent)updatedEvent)) {
            this.clearCaches(updatedEvent);
        }
    }

    @EventListener
    public void onDirectoryReorder(ApplicationDirectoryOrderUpdatedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent event) {
        this.clearCaches(event);
    }

    @EventListener
    public void onGroupMembershipsCreated(GroupMembershipsCreatedEvent e) {
        this.clearUserCountsIfNotInSync((DirectoryEvent)e);
    }

    @EventListener
    public void onGroupMembershipDeleted(GroupMembershipDeletedEvent e) {
        this.clearUserCountsIfNotInSync((DirectoryEvent)e);
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent e) {
        this.clearUserCountsIfNotInSync((DirectoryEvent)e);
    }

    @EventListener
    public void onUserUpdated(UserEditedEvent event) {
        this.clearCacheForUpdatedUser((UserUpdatedEvent)event, (User)event.getOriginalUser(), (User)event.getUser());
    }

    @EventListener
    public void onUserUpdated(AutoUserUpdatedEvent event) {
        this.clearCacheForUpdatedUser((UserUpdatedEvent)event, (User)event.getOriginalUser(), (User)event.getUser());
    }

    @EventListener
    public void onSyncFinished(RemoteDirectorySynchronisationFinishedEvent e) {
        this.clearUserCounts(e);
    }

    @EventListener
    public void onComponentManagerShutdown(ComponentManagerShutdownEvent shutdownEvent) {
        this.cacheRefreshExecutor.shutdown();
    }

    @Override
    @Internal
    public void clearCache() {
        this.appRoleCache.removeAll();
        this.refreshActiveUsersCount();
        this.flushBillableUsersCache();
    }

    private boolean shouldRepopulateCache(DirectoryEvent event) {
        if (!this.featureManager.isEnabled("com.atlassian.jira.ldap.nonblocking.sync.disabled") && this.crowdSyncStatusManager.getDirectorySynchronisationInformation(event.getDirectory()).isSynchronising()) {
            log.debug("Directory (id={}) synchronization is in progress. Delaying repopulating license cache.", (Object)event.getDirectory().getId());
            return false;
        }
        return true;
    }

    public int totalBillableUsers() {
        return (Integer)this.billableUsersCount.get();
    }

    public void flush() {
        this.flushBillableUsersCache();
    }

    public void flushBillableUsersCache() {
        this.billableUsersCount.reset();
    }

    private int getNumberOfSeatsGrantedToRole(@Nonnull ApplicationKey roleKey) {
        int numSeats = 0;
        for (LicenseDetails license : this.licenseManager.getLicenses()) {
            int num = license.getLicensedApplications().getUserLimit(roleKey);
            if (num == 0) continue;
            if (numSeats != 0) {
                throw new IllegalStateException("Application role has users granted in > 1 license: " + roleKey);
            }
            numSeats = num;
        }
        return numSeats;
    }

    private void validateRole(ApplicationRole role) {
        if (!this.licenseManager.getAllLicensedApplicationKeys().contains(role.getKey())) {
            throw new IllegalArgumentException(String.format("The '%s' role is not provided by any license.", role.getKey()));
        }
        for (Group group : role.getGroups()) {
            if (this.groupManager.groupExists(group)) continue;
            throw new IllegalArgumentException(String.format("The '%s' role is associated with group '%s', which does not exist.", role.getKey(), group.getName()));
        }
    }

    private boolean userHasRole(@Nonnull ApplicationUser user, @Nonnull ApplicationRole role) {
        return role.getGroups().stream().anyMatch(group -> this.groupManager.isUserInGroup(user, group));
    }

    private void clearCaches(@Nullable Object event) {
        String eventName = event != null ? event.getClass().getName() : "<UNKNOWN>";
        log.debug("Clearing the cache on {}.", (Object)eventName);
        this.clearCache();
    }

    private void clearUserCountsIfNotInSync(DirectoryEvent event) {
        if (this.shouldRepopulateCache(event)) {
            this.clearUserCounts(event);
        }
    }

    private void clearUserCounts(@Nullable Object event) {
        String eventName = event != null ? event.getClass().getName() : "<UNKNOWN>";
        log.debug("Clearing the user counts on {}.", (Object)eventName);
        this.refreshActiveUsersCount();
        this.flushBillableUsersCache();
    }

    private void clearCacheForUpdatedUser(@Nullable UserUpdatedEvent event, User originalUser, @Nullable User updatedUser) {
        if (this.shouldRepopulateCache((DirectoryEvent)event) && (updatedUser == null || originalUser.isActive() != updatedUser.isActive())) {
            this.clearUserCounts(event);
        }
    }

    private void clearCacheLine(ApplicationKey key) {
        log.debug("Clearing the cache line {}.", (Object)key);
        if (!ApplicationKeys.CORE.equals((Object)key)) {
            this.appRoleCache.remove((Object)ApplicationKeys.CORE);
        }
        this.appRoleCache.remove((Object)key);
        this.refreshActiveUsersCount();
        this.flushBillableUsersCache();
    }

    private static Iterable<String> groupNames(Collection<Group> groups) {
        return (Iterable)groups.stream().map(Group::getName).collect(CollectorsUtil.toImmutableSet());
    }

    private ApplicationRole applicationRoleDefinitionToApplicationRole(@Nonnull ApplicationKey key, @NotNull ApplicationRoleDefinitions.ApplicationRoleDefinition appDef) {
        ApplicationRoleStore.ApplicationRoleData applicationRoleData = this.applicationRoleStore.get(key);
        Set realGroups = (Set)applicationRoleData.getGroups().stream().map(arg_0 -> ((GroupManager)this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
        Set defaultGroups = (Set)applicationRoleData.getDefaultGroups().stream().map(arg_0 -> ((GroupManager)this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).filter(realGroups::contains).collect(CollectorsUtil.toImmutableSet());
        return new DefinitionApplicationRole(this.definitions, appDef, realGroups, defaultGroups, this.getNumberOfSeatsGrantedToRole(key), applicationRoleData.isSelectedByDefault());
    }

    private int countApplicationUsers(ApplicationRole role) {
        Stopwatch timer = Stopwatch.createStarted();
        int count = ApplicationKeys.CORE.equals((Object)role.getKey()) ? this.countCoreUsers() : this.countApplicationRoleUsers(role);
        log.debug("{} count: {}", (Object)role.getName(), (Object)count);
        log.debug("Count application users: {} {}", (Object)timer, (Object)role.getName());
        return count;
    }

    private int countApplicationRoleUsers(ApplicationRole role) {
        Set<String> groupNames = role.getGroups().stream().map(Group::getName).collect(Collectors.toSet());
        return this.countUsersInGroups(groupNames);
    }

    private int countCoreUsers() {
        Set<String> nonCoreGroupNames = this.getRoles().stream().filter(appRole -> !appRole.getKey().equals((Object)ApplicationKeys.CORE) && !this.isRoleLimitExceededCurrentValue(appRole.getKey())).flatMap(appRole -> appRole.getGroups().stream()).map(Group::getName).collect(Collectors.toSet());
        Set<String> usersInNonCoreGroupsThatAreAlreadyCounted = this.readUsersInGroups(nonCoreGroupNames);
        ApplicationRole coreRole = (ApplicationRole)this.getRole(ApplicationKeys.CORE).getOrThrow(() -> new IllegalStateException("Can't fetch role for core application. CORE role is not available"));
        Set<String> coreGroupNames = coreRole.getGroups().stream().map(Group::getName).collect(Collectors.toSet());
        return this.countUsersInGroupsExcluding(coreGroupNames, usersInNonCoreGroupsThatAreAlreadyCounted);
    }

    private Multimap<Long, String> readExpandedGroupNamesByDirectory(Set<String> groups) {
        HashMultimap groupMap = HashMultimap.create();
        for (Directory directory : this.directoryDao.findAll()) {
            if (!directory.isActive()) continue;
            long directoryId = directory.getId();
            Set groupsForCurrentDirectory = groupMap.get((Object)directoryId);
            groupsForCurrentDirectory.addAll(groups);
            if (!this.isNestedGroup(directory)) continue;
            this.readExpandedGroupNamesForDirectory(directoryId, groupsForCurrentDirectory);
        }
        return groupMap;
    }

    private boolean isNestedGroup(Directory directory) {
        try {
            if (DirectoryType.INTERNAL != directory.getType()) {
                return this.directoryInstanceLoader.getDirectory(directory).supportsNestedGroups();
            }
        }
        catch (DirectoryInstantiationException directoryInstantiationException) {
            // empty catch block
        }
        return Boolean.parseBoolean((String)directory.getAttributes().get("useNestedGroups"));
    }

    private void readExpandedGroupNamesForDirectory(long directoryId, Set<String> groups) {
        boolean more;
        Collection<String> children = groups;
        while (more = groups.addAll(children = this.internalMembershipDao.findGroupChildrenOfGroups(directoryId, children))) {
        }
    }

    private Multimap<Long, String> readUsersInGroupsByDirectory(Multimap<Long, String> groupsForDirectories) {
        HashMultimap usersByDirectory = HashMultimap.create();
        for (Map.Entry directoryToGroupsEntry : groupsForDirectories.asMap().entrySet()) {
            long directoryId = (Long)directoryToGroupsEntry.getKey();
            Collection expandedGroups = (Collection)directoryToGroupsEntry.getValue();
            Collection<String> userNames = this.internalMembershipDao.findUserChildrenOfGroups(directoryId, expandedGroups);
            usersByDirectory.putAll((Object)directoryId, (Iterable)userNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet()));
        }
        return usersByDirectory;
    }

    private Set<String> readUsersInGroups(Set<String> groupNames) {
        return this.readUsersInGroupsExcluding(groupNames, Collections.emptySet());
    }

    private Set<String> readUsersInGroupsExcluding(Set<String> groupNames, Set<String> excludeUserIds) {
        HashSet<String> allUsers = new HashSet<String>();
        Stopwatch readExpandedGroupNamesByDirectoryTimer = Stopwatch.createStarted();
        Multimap<Long, String> expandedGroupNamesByDirectory = this.readExpandedGroupNamesByDirectory(groupNames);
        Multimap<Long, String> usersInGroupsByDirectory = this.readUsersInGroupsByDirectory(expandedGroupNamesByDirectory);
        log.debug("Time taken for readExpandedGroupNamesByDirectory: {}", (Object)readExpandedGroupNamesByDirectoryTimer);
        log.debug("Expanded group names by directory: " + expandedGroupNamesByDirectory.size());
        Stopwatch processUsersTimer = Stopwatch.createStarted();
        this.ofBizTransactionManager.withTransaction(t -> this.ofBizUserDao.processUsers(user -> {
            if (!user.isActive()) {
                return;
            }
            String usernameLowerCase = IdentifierUtils.toLowerCase((String)user.getName());
            if (!usersInGroupsByDirectory.get((Object)user.getDirectoryId()).contains(usernameLowerCase)) {
                return;
            }
            if (!excludeUserIds.contains(usernameLowerCase)) {
                allUsers.add(usernameLowerCase);
            }
        }));
        log.debug("Time taken for processing users {}", (Object)processUsersTimer);
        return allUsers;
    }

    private int countUsersInGroups(Set<String> groupNames) {
        return this.readUsersInGroups(groupNames).size();
    }

    private int countUsersInGroupsExcluding(Set<String> groupNames, Set<String> excludeUserIds) {
        return this.readUsersInGroupsExcluding(groupNames, excludeUserIds).size();
    }

    private GlobalPermissionManager getGlobalPermissionManager() {
        return (GlobalPermissionManager)ComponentAccessor.getComponent(GlobalPermissionManager.class);
    }

    private void logDiffForRole(@Nonnull ApplicationRole newRole) {
        Option<ApplicationRole> oldRole = this.getRole(newRole.getKey());
        ApplicationRoleDiff diff = ApplicationRoleDiff.diff(oldRole, newRole);
        this.storeRecord(newRole, diff);
    }

    private void storeRecord(@Nonnull ApplicationRole newRole, @Nonnull ApplicationRoleDiff diff) {
        AuditingService auditingService = (AuditingService)ComponentAccessor.getComponent(AuditingService.class);
        if (auditingService != null && !diff.isEmpty()) {
            auditingService.storeRecord(AUDIT_CATEGORY, diff.summary(), (AssociatedItem)new AffectedApplication(newRole), diff.messages(), null, null);
        }
    }

    private final class BillableUserCountLoader
    implements Supplier<Integer> {
        private BillableUserCountLoader() {
        }

        public Integer get() {
            Stopwatch timer = Stopwatch.createStarted();
            Set<Group> groupsThatGrantUserAccess = this.getGroupsThatGrantUserAccess();
            Set groupNames = groupsThatGrantUserAccess.stream().map(Group::getName).collect(Collectors.toSet());
            log.debug("Time taken for reading base group names: {}", (Object)timer);
            int count = DefaultApplicationRoleManager.this.countUsersInGroups(groupNames);
            log.debug("License check time: {}", (Object)timer);
            return count;
        }

        private Set<Group> getGroupsThatGrantUserAccess() {
            return DefaultApplicationRoleManager.this.getGroupsForLicensedRoles();
        }
    }

    private class RoleLoader
    implements CacheLoader<ApplicationKey, Option<ApplicationRole>> {
        private RoleLoader() {
        }

        @Nonnull
        public Option<ApplicationRole> load(@Nonnull ApplicationKey key) {
            return DefaultApplicationRoleManager.this.definitions.getLicensed(key).map(appDef -> {
                ApplicationRoleStore.ApplicationRoleData applicationRoleData = DefaultApplicationRoleManager.this.applicationRoleStore.get(key);
                Set realGroups = (Set)applicationRoleData.getGroups().stream().map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableSet());
                Set defaultGroups = (Set)applicationRoleData.getDefaultGroups().stream().map(arg_0 -> ((GroupManager)DefaultApplicationRoleManager.this.groupManager).getGroup(arg_0)).filter(Objects::nonNull).filter(realGroups::contains).collect(CollectorsUtil.toImmutableSet());
                return new DefinitionApplicationRole(DefaultApplicationRoleManager.this.definitions, (ApplicationRoleDefinitions.ApplicationRoleDefinition)appDef, realGroups, defaultGroups, DefaultApplicationRoleManager.this.getNumberOfSeatsGrantedToRole(key), applicationRoleData.isSelectedByDefault());
            });
        }
    }

    static class DelegatingSettableFutureTask
    extends FutureTask<Void> {
        private volatile Future futureTask;

        DelegatingSettableFutureTask(Runnable runnable) {
            super(runnable, null);
        }

        public void setDelegate(Future futureTask) {
            this.futureTask = futureTask;
            this.set(null);
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            super.get(timeout, unit);
            if (this.futureTask != null) {
                this.futureTask.get(timeout, unit);
            }
            return null;
        }
    }
}

