/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class ReversibleFileOperations
implements AutoCloseable {
    private final Deque<ReversibleOperation> operations = new ArrayDeque<ReversibleOperation>();

    public void removeOnRollback(File file) {
        this.operations.push(new ReversibleFileCreation(file));
    }

    public void fileDelete(File file) throws IOException {
        if (file.exists()) {
            this.operations.push(ReversibleFileDeletion.delete(file));
        }
    }

    public void commit() throws IOException {
        Iterator<ReversibleOperation> reversibleOperationIterator = this.operations.iterator();
        while (reversibleOperationIterator.hasNext()) {
            reversibleOperationIterator.next().commit();
            reversibleOperationIterator.remove();
        }
    }

    @Override
    public void close() throws IOException {
        Iterator<ReversibleOperation> reversibleOperationIterator = this.operations.iterator();
        while (reversibleOperationIterator.hasNext()) {
            reversibleOperationIterator.next().revert();
            reversibleOperationIterator.remove();
        }
    }

    private static class ReversibleFileDeletion
    implements ReversibleOperation {
        private final File deletedFile;
        private final File tempFile;

        public static ReversibleOperation delete(File deletedFile) throws IOException {
            ReversibleFileDeletion reversibleFileDeletion = new ReversibleFileDeletion(deletedFile);
            reversibleFileDeletion.perform();
            return reversibleFileDeletion;
        }

        private ReversibleFileDeletion(File deletedFile) throws IOException {
            this.deletedFile = deletedFile;
            this.tempFile = File.createTempFile("rfo-", ".temp", deletedFile.getParentFile());
        }

        void perform() throws IOException {
            if (!this.tempFile.delete()) {
                throw new IOException("Cannot delete temp file: " + this.tempFile);
            }
            if (!this.deletedFile.renameTo(this.tempFile)) {
                throw new IOException("Cannot rename file: " + this.deletedFile + " to " + this.tempFile);
            }
        }

        @Override
        public void revert() throws IOException {
            if (!this.tempFile.renameTo(this.deletedFile)) {
                throw new IOException("Cannot rename file: " + this.tempFile + " to " + this.deletedFile);
            }
        }

        @Override
        public void commit() throws IOException {
            if (!this.tempFile.delete()) {
                throw new IOException("Cannot delete temp file: " + this.tempFile);
            }
        }
    }

    private static class ReversibleFileCreation
    implements ReversibleOperation {
        private final File createdFile;

        private ReversibleFileCreation(File createdFile) {
            this.createdFile = createdFile;
        }

        @Override
        public void revert() throws IOException {
            if (this.createdFile.exists() && !this.createdFile.delete()) {
                throw new IOException("Cannot revert file creation: " + this.createdFile);
            }
        }

        @Override
        public void commit() throws IOException {
        }
    }

    private static interface ReversibleOperation {
        public void revert() throws IOException;

        public void commit() throws IOException;
    }
}

