/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.AnnouncementBannerHandler;
import com.atlassian.jira.auditing.handlers.ApplicationLinksEventHandler;
import com.atlassian.jira.auditing.handlers.CommentReactionsHandler;
import com.atlassian.jira.auditing.handlers.CustomFieldHandler;
import com.atlassian.jira.auditing.handlers.EmailEventHandler;
import com.atlassian.jira.auditing.handlers.EmailTemplatesEventHandler;
import com.atlassian.jira.auditing.handlers.FieldLayoutSchemeChangeHandler;
import com.atlassian.jira.auditing.handlers.FlowRequestEventHandler;
import com.atlassian.jira.auditing.handlers.GeneralConfigurationChangesEventHandler;
import com.atlassian.jira.auditing.handlers.GroupEventHandler;
import com.atlassian.jira.auditing.handlers.IssueExportHandler;
import com.atlassian.jira.auditing.handlers.IssueLinkingHandler;
import com.atlassian.jira.auditing.handlers.IssueSecurityLevelHandler;
import com.atlassian.jira.auditing.handlers.IssueTypeAuditHandler;
import com.atlassian.jira.auditing.handlers.IssueTypeScreenSchemeEventHandler;
import com.atlassian.jira.auditing.handlers.JiraUpgradeEventHandler;
import com.atlassian.jira.auditing.handlers.MonitoringEventHandler;
import com.atlassian.jira.auditing.handlers.NotificationChangeHandler;
import com.atlassian.jira.auditing.handlers.PermissionChangeHandler;
import com.atlassian.jira.auditing.handlers.PluginEventHandler;
import com.atlassian.jira.auditing.handlers.PriorityEventHandler;
import com.atlassian.jira.auditing.handlers.ProjectComponentEventHandler;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.auditing.handlers.SchemeEventHandler;
import com.atlassian.jira.auditing.handlers.ScreensEventHandler;
import com.atlassian.jira.auditing.handlers.ServiceEventHandler;
import com.atlassian.jira.auditing.handlers.SharedEntityEventHandler;
import com.atlassian.jira.auditing.handlers.StatusEventHandler;
import com.atlassian.jira.auditing.handlers.SystemAuditEventHandler;
import com.atlassian.jira.auditing.handlers.TerminologyAuditHandler;
import com.atlassian.jira.auditing.handlers.UserDefaultSettingsEventHandler;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.auditing.handlers.VersionEventHandler;
import com.atlassian.jira.auditing.handlers.WorkflowEventHandler;
import com.atlassian.jira.cluster.zdu.JiraUpgradeApprovedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeCancelledEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFailedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeStartedEvent;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.ExportEvent;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowCreatedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.jira.event.WorkflowRenamedEvent;
import com.atlassian.jira.event.WorkflowUpdatedEvent;
import com.atlassian.jira.event.announcement.AnnouncementBannerChangedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentArchivedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentCreatedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentDeletedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentMergedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentRestoredEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentUpdatedEvent;
import com.atlassian.jira.event.config.IssueTypeCreatedEvent;
import com.atlassian.jira.event.config.IssueTypeDeletedEvent;
import com.atlassian.jira.event.config.SubTasksStateChangedEvent;
import com.atlassian.jira.event.fields.PriorityCreatedEvent;
import com.atlassian.jira.event.fields.PriorityDeletedEvent;
import com.atlassian.jira.event.fields.PriorityEditedEvent;
import com.atlassian.jira.event.fields.PriorityMovedEvent;
import com.atlassian.jira.event.fields.StatusCreatedEvent;
import com.atlassian.jira.event.fields.StatusDeletedEvent;
import com.atlassian.jira.event.fields.StatusEditedEvent;
import com.atlassian.jira.event.fields.StatusMovedEvent;
import com.atlassian.jira.event.fields.layout.AbstractFieldLayoutSchemeEntityEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeAddedToProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCopiedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeDeletedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityRemovedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityUpdatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeUpdatedEvent;
import com.atlassian.jira.event.issue.ArchivedIssueExportEvent;
import com.atlassian.jira.event.issue.field.CustomFieldCreatedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldDeletedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldUpdatedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRenamedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkDeletedEvent;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelUpdatedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeAddedToProjectEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeRemovedFromScreenSchemeEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeAssociateScreenSchemeEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeCreatedEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeDeletedEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeUpdatedEvent;
import com.atlassian.jira.event.mail.EmailQueueFlushedEvent;
import com.atlassian.jira.event.mail.OutgoingEmailConfigurationChangedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesAppliedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesDownloadedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesRevertedEvent;
import com.atlassian.jira.event.mail.template.EmailTemplatesUploadedEvent;
import com.atlassian.jira.event.notification.NotificationAddedEvent;
import com.atlassian.jira.event.notification.NotificationDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeAddedToProjectEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCopiedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCreatedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.notification.NotificationSchemeUpdatedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionAddedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionAddedEvent;
import com.atlassian.jira.event.permission.PermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeAddedToProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCopiedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCreatedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeUpdatedEvent;
import com.atlassian.jira.event.project.AbstractVersionEvent;
import com.atlassian.jira.event.project.ProjectArchivedEvent;
import com.atlassian.jira.event.project.ProjectAvatarUpdateEvent;
import com.atlassian.jira.event.project.ProjectCategoryChangeEvent;
import com.atlassian.jira.event.project.ProjectCategoryUpdateEvent;
import com.atlassian.jira.event.project.ProjectRestoredEvent;
import com.atlassian.jira.event.project.VersionArchiveEvent;
import com.atlassian.jira.event.project.VersionCreateEvent;
import com.atlassian.jira.event.project.VersionDeleteEvent;
import com.atlassian.jira.event.project.VersionMergeEvent;
import com.atlassian.jira.event.project.VersionReleaseEvent;
import com.atlassian.jira.event.project.VersionUnarchiveEvent;
import com.atlassian.jira.event.project.VersionUnreleaseEvent;
import com.atlassian.jira.event.project.VersionUpdatedEvent;
import com.atlassian.jira.event.property.BooleanApplicationPropertySetEvent;
import com.atlassian.jira.event.role.ProjectRoleCreatedEvent;
import com.atlassian.jira.event.role.ProjectRoleDeletedEvent;
import com.atlassian.jira.event.role.ProjectRoleUpdatedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.event.service.ServiceDeletedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityCreatedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityDeletedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityUpdatedEvent;
import com.atlassian.jira.event.user.CannotChangePasswordEvent;
import com.atlassian.jira.event.user.ForgotPasswordEvent;
import com.atlassian.jira.event.user.ForgotUsernameEvent;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.event.user.LoginFailedEvent;
import com.atlassian.jira.event.user.UserDefaultSettingsUpdatedEvent;
import com.atlassian.jira.event.user.UserRenamedEvent;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationFinishedEvent;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationStartedEvent;
import com.atlassian.jira.event.user.anonymize.UserKeyChangedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeAddedToProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCopiedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCreatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeDeletedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeUpdatedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.i18n.terminology.TerminologyEntryChangedEvent;
import com.atlassian.jira.license.ConfirmEvaluationLicenseEvent;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.monitoring.jmx.JmxConfigurationChangedEvent;
import com.atlassian.jira.reactions.analytics.CommentReactionsDisabledEvent;
import com.atlassian.jira.reactions.analytics.CommentReactionsEnabledEvent;
import com.atlassian.oauth2.client.api.lib.event.FlowRequestCompletedEvent;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginInstalledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import io.atlassian.fugue.Effect;
import java.util.Optional;

public class AuditingEventListener
implements Startable {
    private final AuditingManager auditingManager;
    private final EventPublisher eventPublisher;
    private final PermissionChangeHandler permissionChangeHandler;
    private final GroupEventHandler groupEventHandler;
    private final SchemeEventHandler schemeEventHandler;
    private final UserEventHandler userEventHandler;
    private final WorkflowEventHandler workflowEventHandler;
    private final NotificationChangeHandler notificationChangeHandler;
    private final FieldLayoutSchemeChangeHandler fieldLayoutSchemeChangeHandler;
    private final ProjectEventHandler projectEventHandler;
    private final ProjectComponentEventHandler projectComponentEventHandler;
    private final VersionEventHandler versionEventHandler;
    private final SystemAuditEventHandler systemAuditEventHandler;
    private final JiraUpgradeEventHandler jiraUpgradeEventHandler;
    private final ScreensEventHandler screensEventHandler;
    private final IssueTypeAuditHandler issueTypeAuditHandler;
    private final GeneralConfigurationChangesEventHandler generalConfigurationChangesEventHandler;
    private final SharedEntityEventHandler sharedEntityEventHandler;
    private final MonitoringEventHandler monitoringEventHandler;
    private final ServiceEventHandler serviceEventHandler;
    private final EmailEventHandler emailEventHandler;
    private final EmailTemplatesEventHandler emailTemplatesEventHandler;
    private final UserDefaultSettingsEventHandler userDefaultSettingsEventHandler;
    private final AnnouncementBannerHandler announcementBannerHandler;
    private final IssueTypeScreenSchemeEventHandler issueTypeScreenSchemeEventHandler;
    private final IssueLinkingHandler issueLinkingHandler;
    private final ApplicationLinksEventHandler applicationLinksEventHandler;
    private final PluginEventHandler pluginEventHandler;
    private final StatusEventHandler statusHandler;
    private final PriorityEventHandler priorityEventHandler;
    private final IssueSecurityLevelHandler issueSecurityLevelHandler;
    private final FlowRequestEventHandler flowRequestEventHandler;
    private final TerminologyAuditHandler terminologyAuditHandler;
    private final CommentReactionsHandler commentReactionsHandler;
    private final IssueExportHandler issueExportHandler;

    public AuditingEventListener(AuditingManager auditingManager, EventPublisher eventPublisher, PermissionChangeHandler permissionChangeHandler, GroupEventHandler groupEventHandler, SchemeEventHandler schemeEventHandler, UserEventHandler userEventHandler, WorkflowEventHandler workflowEventHandler, NotificationChangeHandler notificationChangeHandler, FieldLayoutSchemeChangeHandler fieldLayoutSchemeChangeHandler, ProjectEventHandler projectEventHandler, ProjectComponentEventHandler projectComponentEventHandler, VersionEventHandler versionEventHandler, SystemAuditEventHandler systemAuditEventHandler, JiraUpgradeEventHandler jiraUpgradeEventHandler, ScreensEventHandler screensEventHandler, IssueTypeAuditHandler issueTypeAuditHandler, GeneralConfigurationChangesEventHandler configurationChangesEvenHandler, SharedEntityEventHandler sharedEntityEventHandler, MonitoringEventHandler monitoringEventHandler, ServiceEventHandler serviceEventHandler, EmailEventHandler emailEventHandler, EmailTemplatesEventHandler emailTemplatesEventHandler, UserDefaultSettingsEventHandler userDefaultSettingsEventHandler, AnnouncementBannerHandler announcementBannerHandler, IssueTypeScreenSchemeEventHandler issueTypeScreenSchemeEventHandler, IssueLinkingHandler issueLinkingHandler, ApplicationLinksEventHandler applicationLinksEventHandler, PluginEventHandler pluginEventHandler, StatusEventHandler statusHandler, PriorityEventHandler priorityEventHandler, IssueSecurityLevelHandler issueSecurityLevelHandler, FlowRequestEventHandler flowRequestEventHandler, TerminologyAuditHandler terminologyAuditHandler, CommentReactionsHandler commentReactionsHandler, IssueExportHandler issueExportHandler) {
        this.auditingManager = auditingManager;
        this.eventPublisher = eventPublisher;
        this.permissionChangeHandler = permissionChangeHandler;
        this.groupEventHandler = groupEventHandler;
        this.schemeEventHandler = schemeEventHandler;
        this.userEventHandler = userEventHandler;
        this.workflowEventHandler = workflowEventHandler;
        this.notificationChangeHandler = notificationChangeHandler;
        this.fieldLayoutSchemeChangeHandler = fieldLayoutSchemeChangeHandler;
        this.projectEventHandler = projectEventHandler;
        this.projectComponentEventHandler = projectComponentEventHandler;
        this.versionEventHandler = versionEventHandler;
        this.systemAuditEventHandler = systemAuditEventHandler;
        this.jiraUpgradeEventHandler = jiraUpgradeEventHandler;
        this.screensEventHandler = screensEventHandler;
        this.issueTypeAuditHandler = issueTypeAuditHandler;
        this.generalConfigurationChangesEventHandler = configurationChangesEvenHandler;
        this.sharedEntityEventHandler = sharedEntityEventHandler;
        this.monitoringEventHandler = monitoringEventHandler;
        this.serviceEventHandler = serviceEventHandler;
        this.emailEventHandler = emailEventHandler;
        this.emailTemplatesEventHandler = emailTemplatesEventHandler;
        this.userDefaultSettingsEventHandler = userDefaultSettingsEventHandler;
        this.announcementBannerHandler = announcementBannerHandler;
        this.issueTypeScreenSchemeEventHandler = issueTypeScreenSchemeEventHandler;
        this.issueLinkingHandler = issueLinkingHandler;
        this.applicationLinksEventHandler = applicationLinksEventHandler;
        this.pluginEventHandler = pluginEventHandler;
        this.statusHandler = statusHandler;
        this.priorityEventHandler = priorityEventHandler;
        this.issueSecurityLevelHandler = issueSecurityLevelHandler;
        this.flowRequestEventHandler = flowRequestEventHandler;
        this.terminologyAuditHandler = terminologyAuditHandler;
        this.commentReactionsHandler = commentReactionsHandler;
        this.issueExportHandler = issueExportHandler;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onUserCreation(UserCreatedEvent event) {
        this.auditingManager.store(this.userEventHandler.onUserCreatedEvent(event));
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent event) {
        this.userEventHandler.onUserDeletedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onUserLoginSuccessful(LoginEvent event) {
        this.userEventHandler.onUserLoggedIn(event);
    }

    @EventListener
    public void onUserLoginFailed(LoginFailedEvent event) {
        this.userEventHandler.onUserLoginFailed(event);
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent event) {
        this.userEventHandler.onUserRenamedEvent(event);
    }

    @EventListener
    public void onUserUpdatedEvent(UserUpdatedEvent event) {
        this.userEventHandler.onUserUpdatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onUserCredentialUpdatedEvent(UserCredentialUpdatedEvent event) {
        this.auditingManager.store(this.userEventHandler.onUserCredentialUpdatedEvent(event));
    }

    @EventListener
    public void onUserAnonymizationStarted(UserAnonymizationStartedEvent event) {
        this.auditingManager.store(this.userEventHandler.onUserAnonymizationStartedEvent(event));
    }

    @EventListener
    public void onUserAnonymizationFinished(UserAnonymizationFinishedEvent event) {
        this.auditingManager.store(this.userEventHandler.onUserAnonymizationFinishedEvent(event));
    }

    @EventListener
    public void onUserKeyChanged(UserKeyChangedEvent event) {
        this.auditingManager.store(this.userEventHandler.onUserKeyChangedEvent(event));
    }

    @EventListener
    public void onUserForgotPassword(ForgotPasswordEvent event) {
        this.userEventHandler.onForgotPasswordEvent(event);
    }

    @EventListener
    public void onUserCannotChangePassword(CannotChangePasswordEvent event) {
        this.userEventHandler.onCannotChangePasswordEvent(event);
    }

    @EventListener
    public void onUserForgotUsername(ForgotUsernameEvent event) {
        this.userEventHandler.onForgotUsernameEvent(event);
    }

    @EventListener
    public void onGroupCreatedEvent(GroupCreatedEvent event) {
        this.groupEventHandler.onGroupCreatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent event) {
        this.groupEventHandler.onGroupDeletedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent event) {
        this.groupEventHandler.onGroupMembershipCreatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        this.groupEventHandler.onGroupMembershipDeletedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onPermissionSchemeCreated(PermissionSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent((AbstractSchemeEvent)event));
    }

    @EventListener
    public void onPermissionSchemeCopied(PermissionSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent((AbstractSchemeCopiedEvent)event));
    }

    @EventListener
    public void onPermissionSchemeDeleted(PermissionSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onPermissionSchemeUpdated(PermissionSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent((AbstractSchemeUpdatedEvent)event));
    }

    @EventListener
    public void onPermissionAddedEvent(PermissionAddedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onPermissionAddedEvent(event));
    }

    @EventListener
    public void onPermissionDeletedEvent(PermissionDeletedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onPermissionDeletedEvent(event));
    }

    @EventListener
    public void onGlobalPermissionAdded(GlobalPermissionAddedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onGlobalPermissionAddedEvent(event));
    }

    @EventListener
    public void onGlobalPermissionRemoved(GlobalPermissionDeletedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onGlobalPermissionDeletedEvent(event));
    }

    @EventListener
    public void onWorkflowSchemeCreatedEvent(WorkflowSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent((AbstractSchemeEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeCopiedEvent(WorkflowSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent((AbstractSchemeCopiedEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeDeletedEvent(WorkflowSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onWorkflowSchemeUpdatedEvent(WorkflowSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent((AbstractSchemeUpdatedEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeAddedToProjectEvent(WorkflowSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeRemovedFromProjectEvent(WorkflowSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onWorkflowCreatedEvent(WorkflowCreatedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowCreatedEvent(event));
    }

    @EventListener
    public void onWorkflowCopiedEvent(WorkflowCopiedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowCopiedEvent(event));
    }

    @EventListener
    public void onWorkflowDeletedEvent(WorkflowDeletedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowDeletedEvent(event));
    }

    @EventListener
    public void onWorkflowDeletedEvent(WorkflowUpdatedEvent event) {
        this.workflowEventHandler.onWorkflowUpdatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onDraftWorkflowPublishedEvent(DraftWorkflowPublishedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onDraftWorkflowPublishedEvent(event));
    }

    @EventListener
    public void onWorkflowRenamedEvent(WorkflowRenamedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowRenamedEvent(event));
    }

    @EventListener
    public void onNotificationSchemeCreatedEvent(NotificationSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent((AbstractSchemeEvent)event));
    }

    @EventListener
    public void onNotificationSchemeDeletedEvent(NotificationSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onNotificationSchemeCopiedEvent(NotificationSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent((AbstractSchemeCopiedEvent)event));
    }

    @EventListener
    public void onNotificationSchemeUpdatedEvent(NotificationSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent((AbstractSchemeUpdatedEvent)event));
    }

    @EventListener
    public void onNotificationAddedEvent(NotificationAddedEvent event) {
        this.auditingManager.store(this.notificationChangeHandler.onNotificationAddedEvent(event));
    }

    @EventListener
    public void onNotificationDeletedEvent(NotificationDeletedEvent event) {
        this.auditingManager.store(this.notificationChangeHandler.onNotificationDeletedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeCreatedEvent(FieldLayoutSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeCopiedEvent(FieldLayoutSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeUpdatedEvent(FieldLayoutSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeDeletedEvent(FieldLayoutSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onCustomFieldCreatedEvent(CustomFieldCreatedEvent event) {
        this.auditingManager.store(CustomFieldHandler.onCustomFieldCreatedEvent(event));
    }

    @EventListener
    public void onCustomFieldUpdatedEvent(CustomFieldUpdatedEvent event) {
        this.auditingManager.store(CustomFieldHandler.onCustomFieldUpdatedEvent(event));
    }

    @EventListener
    public void onCustomFieldDeletedEvent(CustomFieldDeletedEvent event) {
        this.auditingManager.store(CustomFieldHandler.onCustomFieldDeletedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeEntityCreatedEvent(FieldLayoutSchemeEntityCreatedEvent event) {
        this.auditingManager.store(this.fieldLayoutSchemeChangeHandler.onFieldLayoutSchemeEntityEvent((AbstractFieldLayoutSchemeEntityEvent)event));
    }

    @EventListener
    public void onFieldLayoutSchemeEntityRemovedEvent(FieldLayoutSchemeEntityRemovedEvent event) {
        this.auditingManager.store(this.fieldLayoutSchemeChangeHandler.onFieldLayoutSchemeEntityEvent((AbstractFieldLayoutSchemeEntityEvent)event));
    }

    @EventListener
    public void onFieldLayoutSchemeEntityUpdatedEvent(FieldLayoutSchemeEntityUpdatedEvent event) {
        this.auditingManager.store(this.fieldLayoutSchemeChangeHandler.onFieldLayoutSchemeEntityUpdatedEvent(event));
    }

    private Effect<RecordRequest> store() {
        return recordRequest -> this.auditingManager.store(recordRequest);
    }

    @EventListener
    public void onNotificationSchemeAddedToProjectEvent(NotificationSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onNotificationSchemeRemovedFromProjectEvent(NotificationSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onIssueSecuritySchemeAddedToProjectEvent(IssueSecuritySchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onIssueSecuritySchemeRemovedFromProjectEvent(IssueSecuritySchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onPermissionSchemeAddedToProjectEvent(PermissionSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onPermissionSchemeRemovedFromProjectEvent(PermissionSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onFieldLayoutSchemeAddedToProjectEvent(FieldLayoutSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject(event));
    }

    @EventListener
    public void onFieldLayoutSchemeRemovedFromProjectEvent(FieldLayoutSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject(event));
    }

    @EventListener
    public void onProjectCreatedEvent(ProjectCreatedEvent event) {
        this.projectEventHandler.onProjectCreatedEvent(event);
    }

    @EventListener
    public void onProjectUpdatedEvent(ProjectUpdatedEvent event) {
        this.projectEventHandler.onProjectUpdatedEvent(event);
    }

    @EventListener
    public void onProjectDeletedEvent(ProjectDeletedEvent event) {
        this.projectEventHandler.onProjectDeletedEvent(event);
    }

    @EventListener
    public void onProjectComponentCreatedEvent(ProjectComponentCreatedEvent event) {
        this.auditingManager.store(this.projectComponentEventHandler.onProjectComponentCreatedEvent(event));
    }

    @EventListener
    public void onProjectComponentUpdatedEvent(ProjectComponentUpdatedEvent event) {
        this.projectComponentEventHandler.onProjectComponentUpdatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onProjectComponentMergedEvent(ProjectComponentMergedEvent event) {
        this.auditingManager.store(this.projectComponentEventHandler.onProjectComponentMergedEvent(event));
    }

    @EventListener
    public void onProjectComponentDeletedEvent(ProjectComponentDeletedEvent event) {
        this.auditingManager.store(this.projectComponentEventHandler.onProjectComponentDeletedEvent(event));
    }

    @EventListener
    public void onProjectComponentArchivedEvent(ProjectComponentArchivedEvent event) {
        this.auditingManager.store(this.projectComponentEventHandler.onProjectComponentArchivedEvent(event));
    }

    @EventListener
    public void onProjectComponentRestoredEvent(ProjectComponentRestoredEvent event) {
        this.auditingManager.store(this.projectComponentEventHandler.onProjectComponentRestoredEvent(event));
    }

    @EventListener
    public void onVersionArchiveEvent(VersionArchiveEvent event) {
        this.auditingManager.store(this.versionEventHandler.onVersionArchiveEvent(event));
    }

    @EventListener
    public void onVersionCreateEvent(VersionCreateEvent event) {
        this.auditingManager.store(this.versionEventHandler.onVersionCreateEvent((AbstractVersionEvent)event));
    }

    @EventListener
    public void onVersionDeleteEvent(VersionDeleteEvent event) {
        this.auditingManager.store(this.versionEventHandler.onVersionDeleteEvent((AbstractVersionEvent)event));
    }

    @EventListener
    public void onVersionMergeEvent(VersionMergeEvent event) {
        this.auditingManager.store(this.versionEventHandler.onVersionMergeEvent(event));
    }

    @EventListener
    public void onVersionReleaseEvent(VersionReleaseEvent event) {
        this.auditingManager.store(this.versionEventHandler.onVersionReleaseEvent(event));
    }

    @EventListener
    public void onVersionUnarchiveEvent(VersionUnarchiveEvent event) {
        this.auditingManager.store(this.versionEventHandler.onVersionUnarchiveEvent(event));
    }

    @EventListener
    public void onVersionUnreleaseEvent(VersionUnreleaseEvent event) {
        this.auditingManager.store(this.versionEventHandler.onVersionUnreleaseEvent(event));
    }

    @EventListener
    public void onVersionUpdatedEvent(VersionUpdatedEvent event) {
        this.versionEventHandler.onVersionUpdatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onProjectCategoryChangeEvent(ProjectCategoryChangeEvent event) {
        this.projectEventHandler.onProjectCategoryChangeEvent(event);
    }

    @EventListener
    public void onProjectAvatarChangeEvent(ProjectAvatarUpdateEvent event) {
        this.projectEventHandler.onProjectAvatarUpdateEvent(event);
    }

    @EventListener
    public void onProjectCategoryUpdateEvent(ProjectCategoryUpdateEvent event) {
        this.projectEventHandler.onProjectCategoryUpdateEvent(event);
    }

    @EventListener
    public void onProjectRoleCreatedEvent(ProjectRoleCreatedEvent event) {
        this.projectEventHandler.handleProjectRoleCreatedEvent(event);
    }

    @EventListener
    public void onProjectRoleUpdatedEvent(ProjectRoleUpdatedEvent event) {
        this.projectEventHandler.onProjectRoleUpdatedEvent(event);
    }

    @EventListener
    public void onProjectRoleDeletedEvent(ProjectRoleDeletedEvent event) {
        this.projectEventHandler.onProjectRoleDeletedEvent(event);
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.auditingManager.store(this.systemAuditEventHandler.onLicenseChangedEvent(event));
    }

    @EventListener
    public void onExtendTrialLicense(ConfirmEvaluationLicenseEvent event) {
        this.auditingManager.store(this.systemAuditEventHandler.onExtendTrialLicense(event));
    }

    @EventListener
    public void onJiraUpgradeStartedEvent(JiraUpgradeStartedEvent event) {
        this.auditingManager.store(this.jiraUpgradeEventHandler.onStartedEvent(event));
    }

    @EventListener
    public void onJiraUpgradeCancelledEvent(JiraUpgradeCancelledEvent event) {
        this.auditingManager.store(this.jiraUpgradeEventHandler.onCancelledEvent(event));
    }

    @EventListener
    public void onJiraUpgradeApprovedEvent(JiraUpgradeApprovedEvent event) {
        this.auditingManager.store(this.jiraUpgradeEventHandler.onApprovedEvent(event));
    }

    @EventListener
    public void onJiraUpgradeFinishedEvent(JiraUpgradeFinishedEvent event) {
        this.auditingManager.store(this.jiraUpgradeEventHandler.onFinishedEvent(event));
    }

    @EventListener
    public void onJiraUpgradeFailedEvent(JiraUpgradeFailedEvent event) {
        this.auditingManager.store(this.jiraUpgradeEventHandler.onFailedEvent(event));
    }

    @EventListener
    public void onFieldScreenFieldAddedEvent(FieldScreenFieldAddedEvent event) {
        this.auditingManager.store(this.screensEventHandler.onFieldScreenFieldAddedEvent(event));
    }

    @EventListener
    public void onFieldScreenFieldMovedEvent(FieldScreenFieldMovedEvent event) {
        this.auditingManager.store(this.screensEventHandler.onFieldScreenFieldMovedEvent(event));
    }

    @EventListener
    public void onFieldScreenFieldRemovedEvent(FieldScreenFieldRemovedEvent event) {
        this.auditingManager.store(this.screensEventHandler.onFieldScreenFieldRemovedEvent(event));
    }

    @EventListener
    public void onFieldScreenTabAddedEvent(FieldScreenTabAddedEvent event) {
        this.auditingManager.store(this.screensEventHandler.onFieldScreenTabAddedEvent(event));
    }

    @EventListener
    public void onFieldScreenTabMovedEvent(FieldScreenTabMovedEvent event) {
        this.auditingManager.store(this.screensEventHandler.onFieldScreenTabMovedEvent(event));
    }

    @EventListener
    public void onFieldScreenTabRemovedEvent(FieldScreenTabRemovedEvent event) {
        this.auditingManager.store(this.screensEventHandler.onFieldScreenTabRemovedEvent(event));
    }

    @EventListener
    public void onFieldScreenTabRenamedEvent(FieldScreenTabRenamedEvent event) {
        this.auditingManager.store(this.screensEventHandler.onFieldScreenTabRenamedEvent(event));
    }

    @EventListener
    public void onProjectArchivedEvent(ProjectArchivedEvent event) {
        this.projectEventHandler.onProjectArchivedEvent(event);
    }

    @EventListener
    public void onProjectArchivedEvent(ProjectRestoredEvent event) {
        this.projectEventHandler.onProjectRestoredEvent(event);
    }

    @EventListener
    public void onIssueTypeCreated(IssueTypeCreatedEvent event) {
        this.issueTypeAuditHandler.handleIssueTypeCreated(event.getIssueType());
    }

    @EventListener
    public void onGeneralConfigurationChanged(BooleanApplicationPropertySetEvent event) {
        Optional<RecordRequest> request = Optional.ofNullable(this.generalConfigurationChangesEventHandler.onGeneralConfigurationChanged(event));
        request.ifPresent(arg_0 -> ((AuditingManager)this.auditingManager).store(arg_0));
    }

    @EventListener
    public void onSharedEntityCreatedEvent(SharedEntityCreatedEvent event) {
        this.auditingManager.store(this.sharedEntityEventHandler.onSharedEntityCreated(event));
    }

    @EventListener
    public void onSharedEntityDeletedEvent(SharedEntityDeletedEvent event) {
        this.auditingManager.store(this.sharedEntityEventHandler.onSharedEntityDeleted(event));
    }

    @EventListener
    public void onSharedEntityUpdatedEvent(SharedEntityUpdatedEvent event) {
        this.auditingManager.store(this.sharedEntityEventHandler.onSharedEntityUpdated(event));
    }

    @EventListener
    public void onFeatureEnabledEvent(FeatureEnabledEvent event) {
        this.systemAuditEventHandler.handleFeatureEnabledEvent(event);
    }

    @EventListener
    public void onFeatureDisabledEvent(FeatureDisabledEvent event) {
        this.systemAuditEventHandler.handleFeatureDisabledEvent(event);
    }

    @EventListener
    public void onJmxConfigurationChangedEvent(JmxConfigurationChangedEvent event) {
        this.monitoringEventHandler.handleJmxConfigurationChanged(event);
    }

    @EventListener
    public void onServiceDeletedEvent(ServiceDeletedEvent event) {
        this.serviceEventHandler.handleServiceDeleted(event);
    }

    @EventListener
    public void onEmailConfigurationChangedEvent(OutgoingEmailConfigurationChangedEvent event) {
        this.emailEventHandler.handleEmailConfigurationChanged(event);
    }

    @EventListener
    public void onUserDefaultSettingsUpdatedEvent(UserDefaultSettingsUpdatedEvent event) {
        this.userDefaultSettingsEventHandler.handleUserDefaultSettingsUpdatedEvent(event);
    }

    @EventListener
    public void onEmailQueueFlashedEvent(EmailQueueFlushedEvent event) {
        this.emailEventHandler.handleEmailQueueFlushed(event);
    }

    @EventListener
    public void onEmailTemplatesDownloaded(EmailTemplatesDownloadedEvent event) {
        this.emailTemplatesEventHandler.handleEmailTemplatesDownloadedEvent(event);
    }

    @EventListener
    public void onEmailTemplatesUploaded(EmailTemplatesUploadedEvent event) {
        this.emailTemplatesEventHandler.handleEmailTemplatesUploadedEvent(event);
    }

    @EventListener
    public void onEmailTemplatesApplied(EmailTemplatesAppliedEvent event) {
        this.emailTemplatesEventHandler.handleEmailTemplatesAppliedEvent(event);
    }

    @EventListener
    public void onEmailTemplatesReverted(EmailTemplatesRevertedEvent event) {
        this.emailTemplatesEventHandler.handleEmailTemplatesRevertedEvent(event);
    }

    @EventListener
    public void onSubTasksStateChangedEvent(SubTasksStateChangedEvent event) {
        this.issueTypeAuditHandler.handleSubTasksStateChanged(event);
    }

    @EventListener
    public void onAnnouncementBannerChangedEvent(AnnouncementBannerChangedEvent event) {
        this.announcementBannerHandler.handleAnnouncementBannerChanged(event);
    }

    @EventListener
    public void onIssueTypeDeletedEvent(IssueTypeDeletedEvent event) {
        this.issueTypeAuditHandler.handleIssueTypeDeleted(event.getIssueType());
    }

    @EventListener
    public void onIssueTypeScreenSchemeCreatedEvent(IssueTypeScreenSchemeCreatedEvent event) {
        this.issueTypeScreenSchemeEventHandler.handleIssueTypeScreenSchemeCreated(event);
    }

    @EventListener
    public void onIssueTypeScreenSchemeUpdatedEvent(IssueTypeScreenSchemeUpdatedEvent event) {
        this.issueTypeScreenSchemeEventHandler.handleIssueTypeScreenSchemeUpdated(event);
    }

    @EventListener
    public void onIssueTypeScreenSchemeDeletedEvent(IssueTypeScreenSchemeDeletedEvent event) {
        this.issueTypeScreenSchemeEventHandler.handleIssueTypeScreenSchemeDeleted(event);
    }

    @EventListener
    public void onIssueTypeScreenSchemeAssociatedEvent(IssueTypeScreenSchemeAssociateScreenSchemeEvent event) {
        this.issueTypeScreenSchemeEventHandler.handleIssueTypeScreenSchemeAssociateScreenScheme(event);
    }

    @EventListener
    public void onIssueTypeRemovedFromScreenSchemeEvent(IssueTypeRemovedFromScreenSchemeEvent event) {
        this.issueTypeScreenSchemeEventHandler.handleIssueTypeScreenSchemeRemovedFromScreen(event);
    }

    @EventListener
    public void onIssueLinkCreatedEvent(IssueLinkCreatedEvent event) {
        this.issueLinkingHandler.handleIssueLinkCreation(event);
    }

    @EventListener
    public void onIssueLinkDeletedEvent(IssueLinkDeletedEvent event) {
        this.issueLinkingHandler.handleIssueLinkDeletion(event);
    }

    @EventListener
    public void onApplicationLinkAddedEvent(ApplicationLinkAddedEvent event) {
        this.applicationLinksEventHandler.handleApplicationLinkAddedEvent(event);
    }

    @EventListener
    public void onApplicationLinkChangedEvent(ApplicationLinkDetailsChangedEvent event) {
        this.applicationLinksEventHandler.handleApplicationLinkChangedEvent(event);
    }

    @EventListener
    public void onApplicationLinkDeletedEvent(ApplicationLinkDeletedEvent event) {
        this.applicationLinksEventHandler.handleApplicationLinkDeletedEvent(event);
    }

    @EventListener
    public void onPluginInstalledEvent(PluginInstalledEvent event) {
        this.pluginEventHandler.handlePluginInstalledEvent(event);
    }

    @EventListener
    public void onPluginUninstalledEvent(PluginUninstalledEvent event) {
        this.pluginEventHandler.handlePluginUninstalledEvent(event);
    }

    @EventListener
    public void onPluginUpgradedEvent(PluginUpgradedEvent event) {
        this.pluginEventHandler.handlePluginUpgradedEvent(event);
    }

    @EventListener
    public void onPluginEnabledEvent(PluginEnabledEvent event) {
        this.pluginEventHandler.handlePluginEnabledEvent(event);
    }

    @EventListener
    public void onPluginDisabledEvent(PluginDisabledEvent event) {
        this.pluginEventHandler.handlePluginDisabledEvent(event);
    }

    @EventListener
    public void onStatusCreatedEvent(StatusCreatedEvent event) {
        this.statusHandler.handleStatusCreated(event);
    }

    @EventListener
    public void onStatusEditedEvent(StatusEditedEvent event) {
        this.statusHandler.handleStatusEdited(event);
    }

    @EventListener
    public void onStatusDeletedEvent(StatusDeletedEvent event) {
        this.statusHandler.handleStatusDeleted(event);
    }

    @EventListener
    public void onStatusMovedEvent(StatusMovedEvent event) {
        this.statusHandler.handleStatusMoved(event);
    }

    @EventListener
    public void onPriorityCreatedEvent(PriorityCreatedEvent event) {
        this.priorityEventHandler.handlePriorityCreated(event);
    }

    @EventListener
    public void onPriorityEditedEvent(PriorityEditedEvent event) {
        this.priorityEventHandler.handlePriorityEdited(event);
    }

    @EventListener
    public void onPriorityDeletedEvent(PriorityDeletedEvent event) {
        this.priorityEventHandler.handlePriorityDeleted(event);
    }

    @EventListener
    public void onPriorityMovedEvent(PriorityMovedEvent event) {
        this.priorityEventHandler.handlePriorityMoved(event);
    }

    @EventListener
    public void onIssueSecurityLevelUpdateEvent(IssueSecurityLevelUpdatedEvent event) {
        this.issueSecurityLevelHandler.onIssueSecurityLevelUpdatedEvent(event);
    }

    @EventListener
    public void onFlowRequestCompleted(FlowRequestCompletedEvent event) {
        this.flowRequestEventHandler.handleFlowRequestCompleted(event);
    }

    @EventListener
    public void onTerminologyEntryChangedEvent(TerminologyEntryChangedEvent event) {
        this.terminologyAuditHandler.handleTerminologyEntryChangedEvent(event);
    }

    @EventListener
    public void onCommentReactionsEnabledEvent(CommentReactionsEnabledEvent event) {
        this.commentReactionsHandler.handleCommentReactionEnabled(event);
    }

    @EventListener
    public void onCommentReactionsDisabledEvent(CommentReactionsDisabledEvent event) {
        this.commentReactionsHandler.handleCommentReactionDisabled(event);
    }

    @EventListener
    public void onIssueExportEvent(ExportEvent event) {
        this.issueExportHandler.onIssueExportedEvent(event);
    }

    @EventListener
    public void onArchivedIssueExportEvent(ArchivedIssueExportEvent event) {
        this.issueExportHandler.onArchivedIssueExportedEvent(event);
    }
}

