/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.PreAuditEnricher;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class PreAuditChangedValuesGroupingEnricherImpl
implements PreAuditEnricher {
    @Override
    public AuditEvent apply(AuditEvent auditEvent) {
        if (this.isChangedValuesWithDuplicateI18nKeys(auditEvent)) {
            ChangedValuesBuilder changedValuesBuilder = new ChangedValuesBuilder();
            auditEvent.getChangedValues().stream().collect(Collectors.groupingBy(ChangedValue::getI18nKey)).forEach((key, changedValues) -> changedValuesBuilder.add((String)key, this.mapAndJoin((List<ChangedValue>)changedValues, ChangedValue::getFrom), this.mapAndJoin((List<ChangedValue>)changedValues, ChangedValue::getTo)));
            return new AuditEvent.Builder(auditEvent).changedValues(changedValuesBuilder.build()).build();
        }
        return auditEvent;
    }

    private boolean isChangedValuesWithDuplicateI18nKeys(AuditEvent auditEvent) {
        int size = auditEvent.getChangedValues().size();
        return size > 1 && (long)size > auditEvent.getChangedValues().stream().map(ChangedValue::getI18nKey).distinct().count();
    }

    @Nullable
    private String mapAndJoin(List<ChangedValue> changedValues, Function<ChangedValue, String> mapper) {
        return changedValues.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.joining(", "), Strings::emptyToNull));
    }
}

