/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.converters;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingEntry;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.spis.migration.mapping.CoverageAreaConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class AuditEvents {
    private final CoverageAreaConverter coverageAreaConverter;

    public AuditEvents(CoverageAreaConverter coverageAreaConverter) {
        this.coverageAreaConverter = coverageAreaConverter;
    }

    public AuditEvent from(RecordRequest recordRequest) {
        AuditType auditType = AuditEntitiesUtils.newAuditTypeWithTranslations(this.coverageAreaConverter.apply(recordRequest.getCategory(), CoverageArea.END_USER_ACTIVITY), recordRequest.getCategory().getNameI18nKey(), recordRequest.getActionI18nKey(), CoverageLevel.BASE, recordRequest.getCategory().getId(), recordRequest.getSummary());
        AuditEvent.Builder auditEntityBuilder = AuditEvent.builder((AuditType)auditType);
        this.convertAffectedObject(recordRequest, auditEntityBuilder);
        this.convertChangedValues((Iterable<ChangedValue>)recordRequest.getChangedValues(), auditEntityBuilder);
        return auditEntityBuilder.build();
    }

    public AuditEvent from(AuditingEntry auditingEntry) {
        AuditType auditType = AuditEntitiesUtils.newAuditType(this.coverageAreaConverter.apply(auditingEntry.category(), CoverageArea.END_USER_ACTIVITY), auditingEntry.category(), auditingEntry.getActionI18nKey(), CoverageLevel.BASE);
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)auditType).affectedObjects(this.convertAffectedObjects(auditingEntry));
        Optional.ofNullable(auditingEntry.description()).ifPresent(desc -> builder.extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.extra.parameters.event.description", desc)));
        this.convertChangedValues(auditingEntry.changedValues(), builder);
        return builder.build();
    }

    private void convertChangedValues(Iterable<ChangedValue> changedValues, AuditEvent.Builder auditEventBuilder) {
        if (changedValues != null) {
            StreamSupport.stream(changedValues.spliterator(), false).map(this::convert).forEach(arg_0 -> ((AuditEvent.Builder)auditEventBuilder).changedValue(arg_0));
        }
    }

    private com.atlassian.audit.entity.ChangedValue convert(ChangedValue changedValue) {
        return AuditEntitiesUtils.newChangedValue(changedValue.getName(), changedValue.getFrom(), changedValue.getTo());
    }

    private List<AuditResource> convertAffectedObjects(AuditingEntry auditingEntry) {
        ArrayList<AssociatedItem> associatedItems = new ArrayList<AssociatedItem>();
        associatedItems.add(auditingEntry.objectItem());
        Optional.ofNullable(auditingEntry.associatedItems()).ifPresent(items -> items.forEach(associatedItems::add));
        return associatedItems.stream().map(this::convert).collect(Collectors.toList());
    }

    private void convertAffectedObject(RecordRequest recordRequest, AuditEvent.Builder auditEventBuilder) {
        ArrayList associatedItems = new ArrayList();
        Optional.ofNullable(recordRequest.getObjectItem()).ifPresent(associatedItems::add);
        Optional.ofNullable(recordRequest.getAssociatedItems()).ifPresent(associatedItems::addAll);
        auditEventBuilder.affectedObjects(associatedItems.stream().map(this::convert).collect(Collectors.toList()));
    }

    private AuditResource convert(AssociatedItem associatedItem) {
        if (associatedItem == null) {
            return AuditResources.UNSPECIFIED_NULL_RESOURCE;
        }
        return AuditResource.builder((String)associatedItem.getObjectName(), (String)associatedItem.getObjectType().name()).id(associatedItem.getObjectId()).build();
    }
}

