/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.handlers.AccessDeniedAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;

@AuditExceptionSafe
public class AccessDeniedAuditHandlerImpl
implements AccessDeniedAuditHandler {
    private final AuditService auditService;
    private final JiraAuthenticationContext authContext;
    @VisibleForTesting
    static final AuditType ISSUE_ACCESS_DENIED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, AuditingCategory.PERMISSIONS, "jira.auditing.issue.view.permission.denied", CoverageLevel.FULL);
    @VisibleForTesting
    static final AuditType PROJECT_ACCESS_DENIED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, AuditingCategory.PERMISSIONS, "jira.auditing.project.view.permission.denied", CoverageLevel.FULL);

    public AccessDeniedAuditHandlerImpl(AuditService auditService, JiraAuthenticationContext authContext) {
        this.auditService = auditService;
        this.authContext = authContext;
    }

    @Override
    @ThrowSafe
    public void handleIssueAccessDenied(@Nonnull String issueKey) {
        if (!Users.isAnonymous((ApplicationUser)this.authContext.getLoggedInUser())) {
            this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_ACCESS_DENIED).affectedObject(AuditResource.builder((String)issueKey, (String)AssociatedItem.Type.ISSUE.name()).id(issueKey).build()).build());
        }
    }

    @Override
    @ThrowSafe
    public void handleProjectAccessDenied(@Nonnull String projectKey) {
        if (!Users.isAnonymous((ApplicationUser)this.authContext.getLoggedInUser())) {
            this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_ACCESS_DENIED).affectedObject(AuditResource.builder((String)projectKey, (String)AssociatedItem.Type.PROJECT.name()).id(projectKey).build()).build());
        }
    }
}

