/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.AnnouncementBannerHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.announcement.AnnouncementBannerChangedEvent;
import com.google.common.annotations.VisibleForTesting;

@AuditExceptionSafe
public final class AnnouncementBannerHandlerImpl
implements AnnouncementBannerHandler {
    @VisibleForTesting
    static final AuditType ANNOUNCEMENT_BANNER_UPDATE = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.USER_INTERFACE, "jira.auditing.announcement.banner.updated", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public AnnouncementBannerHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleAnnouncementBannerChanged(AnnouncementBannerChangedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)ANNOUNCEMENT_BANNER_UPDATE).changedValues(new ChangedValuesBuilder().addIfDifferent("jira.auditing.announcement.banner.content", event.getPreviousBanner(), event.getNewBanner()).addIfDifferent("jira.auditing.announcement.banner.visibility", event.getPreviousVisibility(), event.getNewVisibility()).build()).build());
    }
}

