/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.handlers.CommentHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.text.DateFormat;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@AuditExceptionSafe
public class CommentHandlerImpl
implements CommentHandler {
    private static final AuditType OWN_COMMENT_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.PROJECTS, "jira.auditing.issue.comment.deleted.own", CoverageLevel.ADVANCED);
    private static final AuditType ANOTHER_COMMENT_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.PROJECTS, "jira.auditing.issue.comment.deleted.another", CoverageLevel.ADVANCED);
    private static final AuditType ANOTHER_COMMENT_ADDED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.ISSUE, "jira.auditing.issue.comment.added.own", CoverageLevel.FULL);
    private static final AuditType ANOTHER_COMMENT_LIMITED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.ISSUE.getNameI18nKey(), "jira.auditing.issue.comment.limited", CoverageLevel.FULL);
    private static final String UNDEFINED_USER_NAME = null;
    private static final String TRUNCATION_SUFFIX = "...";
    private static final int MAX_BODY_LENGTH = 255 - "...".length();
    private final AuditService auditService;
    private final JiraAuthenticationContext authenticationContext;

    public CommentHandlerImpl(AuditService auditService, JiraAuthenticationContext authenticationContext) {
        this.auditService = auditService;
        this.authenticationContext = authenticationContext;
    }

    @Override
    @ThrowSafe
    public void handleCommentDeleted(Comment deleted) {
        Objects.requireNonNull(deleted);
        Issue issue = deleted.getIssue();
        String originalAuthor = deleted.getAuthorFullName();
        String dateFormatted = this.getOriginalDateFormatted(deleted);
        AuditType auditType = this.authenticationContext.getLoggedInUser().equals((Object)deleted.getAuthorApplicationUser()) ? OWN_COMMENT_DELETED : ANOTHER_COMMENT_DELETED;
        this.auditService.audit(AuditEvent.builder((AuditType)auditType).affectedObject(AuditResources.from(issue)).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.comment.deleted.original.author", originalAuthor)).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.comment.deleted.original.date", dateFormatted)).build());
    }

    @Override
    @ThrowSafe
    public void handleCommentAdded(@Nonnull Comment added) {
        Objects.requireNonNull(added);
        this.auditService.audit(AuditEvent.builder((AuditType)ANOTHER_COMMENT_ADDED).affectedObject(AuditResources.from(added)).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.comment.added.issue.key", added.getIssue().getKey())).build());
    }

    @Override
    @ThrowSafe
    public void handleCommentLimited(@Nonnull Issue issue, @Nullable ApplicationUser author, @Nullable String body, long limitValue) {
        Objects.requireNonNull(issue);
        this.auditService.audit(AuditEvent.builder((AuditType)ANOTHER_COMMENT_LIMITED).affectedObject(AuditResources.from(issue)).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.comment.limited.executor", this.getExecutorName())).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.comment.limited.comment.author", this.getAuthorName(author))).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.comment.limited.comment.body", this.getBody(body))).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.comment.limited.limit", "" + limitValue)).build());
    }

    private String getBody(@Nullable String body) {
        return StringUtils.crop((String)body, (int)MAX_BODY_LENGTH, (String)TRUNCATION_SUFFIX);
    }

    private String getAuthorName(@Nullable ApplicationUser author) {
        return author != null ? author.getName() : UNDEFINED_USER_NAME;
    }

    private String getExecutorName() {
        ApplicationUser executor = this.authenticationContext.getLoggedInUser();
        return executor != null ? executor.getName() : UNDEFINED_USER_NAME;
    }

    @Nonnull
    private String getOriginalDateFormatted(Comment comment) {
        Objects.requireNonNull(comment);
        Date commentDate = comment.getCreated();
        DateFormat dateInstance = DateFormat.getDateInstance(3, this.authenticationContext.getLocale());
        return dateInstance.format(commentDate);
    }
}

