/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.FieldLayoutSchemeChangeHandler;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.event.fields.layout.AbstractFieldLayoutSchemeEntityEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityRemovedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityUpdatedEvent;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldLayoutSchemeChangeHandlerImpl
implements FieldLayoutSchemeChangeHandler {
    private final IssueTypeManager issueTypeManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final I18nHelper.BeanFactory i18n;

    public FieldLayoutSchemeChangeHandlerImpl(IssueTypeManager issueTypeManager, FieldLayoutManager fieldLayoutManager, I18nHelper.BeanFactory i18n) {
        this.issueTypeManager = issueTypeManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.i18n = i18n;
    }

    @Override
    public RecordRequest onFieldLayoutSchemeEntityEvent(AbstractFieldLayoutSchemeEntityEvent event) {
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.layout.scheme.updated").withActionI18nKey("jira.auditing.field.layout.scheme.updated").forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), event.getScheme().getId()).withChangedValues(this.computeChangedValues(event));
    }

    private List<ChangedValue> computeChangedValues(AbstractFieldLayoutSchemeEntityEvent event) {
        String issueTypeName = this.getIssueTypeName(event.getEntityDetails().getIssueTypeId());
        String fieldConfigurationName = this.getFieldLayoutName(event.getEntityDetails().getFieldLayoutId());
        ChangedValuesBuilder builder = new ChangedValuesBuilder();
        if (event instanceof FieldLayoutSchemeEntityCreatedEvent) {
            builder.addIfDifferent("admin.issue.constant.issuetype", "", issueTypeName).addIfDifferent("admin.issuefields.fieldconfigschemes.field.configuration", "", fieldConfigurationName);
        } else if (event instanceof FieldLayoutSchemeEntityRemovedEvent) {
            builder.add("admin.issue.constant.issuetype", issueTypeName, "").addIfDifferent("admin.issuefields.fieldconfigschemes.field.configuration", fieldConfigurationName, "");
        } else {
            throw new UnsupportedOperationException("Missing handler for " + event.getClass().getSimpleName());
        }
        return builder.build();
    }

    private String getIssueTypeName(String issueTypeId) {
        return issueTypeId == null ? this.getI18n().getText("common.words.default") : this.issueTypeManager.getIssueType(issueTypeId).getName();
    }

    @Nonnull
    private String getFieldLayoutName(@Nullable Long fieldLayoutId) {
        EditableFieldLayout fieldLayout = this.fieldLayoutManager.getEditableFieldLayout(fieldLayoutId);
        return fieldLayout.getName();
    }

    @Override
    public RecordRequest onFieldLayoutSchemeEntityUpdatedEvent(FieldLayoutSchemeEntityUpdatedEvent event) {
        String issueTypeName = this.getIssueTypeName(event.getEntityDetails().getIssueTypeId());
        String fieldConfigurationName = this.getFieldLayoutName(event.getEntityDetails().getFieldLayoutId());
        String originalIssueTypeName = this.getIssueTypeName(event.getOriginalEntityDetails().getIssueTypeId());
        String originalFieldConfigurationName = this.getFieldLayoutName(event.getOriginalEntityDetails().getFieldLayoutId());
        ChangedValuesBuilder builder = new ChangedValuesBuilder();
        builder.add("admin.issue.constant.issuetype", originalIssueTypeName, issueTypeName).addIfDifferent("admin.issuefields.fieldconfigschemes.field.configuration", originalFieldConfigurationName, fieldConfigurationName);
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.layout.scheme.updated").withActionI18nKey("jira.auditing.field.layout.scheme.updated").forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), event.getScheme().getId()).withChangedValues(builder.build());
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }
}

