/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.jira.auditing.AffectedGroup;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.GroupEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import io.atlassian.fugue.Option;

public class GroupEventHandlerImpl
implements GroupEventHandler {
    @Override
    public Option<RecordRequest> onGroupCreatedEvent(GroupCreatedEvent event) {
        return Option.some((Object)new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.created").withActionI18nKey("jira.auditing.group.created").forObject((AssociatedItem)new AffectedGroup(event.getGroup().getName(), event.getDirectory())));
    }

    @Override
    public Option<RecordRequest> onGroupDeletedEvent(GroupDeletedEvent event) {
        return Option.some((Object)new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.deleted").withActionI18nKey("jira.auditing.group.deleted").forObject((AssociatedItem)new AffectedGroup(event.getGroupName(), event.getDirectory())));
    }

    @Override
    public Option<RecordRequest> onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent event) {
        if (event.getMembershipType().equals((Object)MembershipType.GROUP_GROUP)) {
            return Option.some((Object)new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.added.to.group").withActionI18nKey("jira.auditing.group.added.to.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName(), event.getDirectory())).withAssociatedItems(new AssociatedItem[]{new AffectedGroup(event.getEntityName(), event.getDirectory())}));
        }
        if (event.getMembershipType().equals((Object)MembershipType.GROUP_USER)) {
            String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getEntityName());
            return Option.some((Object)new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.user.added.to.group").withActionI18nKey("jira.auditing.user.added.to.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName(), event.getDirectory())).withAssociatedItems(new AssociatedItem[]{new AffectedUser(event.getEntityName(), userKey, event.getDirectory())}));
        }
        throw new IllegalArgumentException("Unknown membership type: " + event.getMembershipType());
    }

    @Override
    public Option<RecordRequest> onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        switch (event.getMembershipType()) {
            case GROUP_GROUP: {
                return Option.some((Object)new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.removed.from.group").withActionI18nKey("jira.auditing.group.removed.from.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName(), event.getDirectory())).withAssociatedItems(new AssociatedItem[]{new AffectedGroup(event.getEntityName(), event.getDirectory())}));
            }
            case GROUP_USER: {
                String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getEntityName());
                return Option.some((Object)new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.user.removed.from.group").withActionI18nKey("jira.auditing.user.removed.from.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName(), event.getDirectory())).withAssociatedItems(new AssociatedItem[]{new AffectedUser(event.getEntityName(), userKey, event.getDirectory())}));
            }
        }
        throw new IllegalArgumentException("Unknown membership type: " + event.getMembershipType());
    }
}

