/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.IssueExportHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.ExportEvent;
import com.atlassian.jira.event.issue.ArchivedIssueExportEvent;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@AuditExceptionSafe
public class IssueExportHandlerImpl
implements IssueExportHandler {
    @VisibleForTesting
    static final AuditType ISSUE_EXPORTED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue", "jira.auditing.issues.export", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType ARCHIVED_ISSUE_EXPORTED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue", "jira.auditing.issues.export.archived", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final String JQL_QUERY_KEY = "jira.jql.query";
    @VisibleForTesting
    static final String EXPORTED_ISSUES_KEY = "jira.auditing.issues.export.total";
    @VisibleForTesting
    static final String ALL_PROJECTS_KEY = "jira.auditing.issues.export.all.projects";
    @VisibleForTesting
    static final String EXPORTED_FROM_PROJECTS_KEY = "jira.auditing.issues.export.from.projects";
    @VisibleForTesting
    static final String PROJECTS_KEYS_DELIMITER = ",";
    private final AuditService auditService;
    private final I18nHelper.BeanFactory i18nFactory;

    public IssueExportHandlerImpl(AuditService auditService, I18nHelper.BeanFactory i18nFactory) {
        this.auditService = auditService;
        this.i18nFactory = i18nFactory;
    }

    @Override
    @ThrowSafe
    public void onIssueExportedEvent(ExportEvent event) {
        if (this.isIssueExportEventAuditable(event)) {
            this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_EXPORTED).extraAttributes(this.getExtraAttributes(event)).build());
        }
    }

    private boolean isIssueExportEventAuditable(ExportEvent event) {
        return !event.isTriggeredByApplication() && event.getIssuesTotal().map(issues -> issues > 0L).orElse(false) != false;
    }

    @Override
    @ThrowSafe
    public void onArchivedIssueExportedEvent(ArchivedIssueExportEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)ARCHIVED_ISSUE_EXPORTED).extraAttributes(this.getExtraAttributes(event)).build());
    }

    private List<AuditAttribute> getExtraAttributes(ExportEvent event) {
        ArrayList<AuditAttribute> attributes = new ArrayList<AuditAttribute>();
        event.getJqlString().ifPresent(jqlString -> attributes.add(AuditAttribute.fromI18nKeys((String)JQL_QUERY_KEY, (String)jqlString).build()));
        event.getIssuesTotal().ifPresent(issuesTotal -> attributes.add(AuditAttribute.fromI18nKeys((String)EXPORTED_ISSUES_KEY, (String)String.valueOf(issuesTotal)).build()));
        return attributes;
    }

    private List<AuditAttribute> getExtraAttributes(ArchivedIssueExportEvent event) {
        String issuesTotal = String.valueOf(event.getIssuesTotal());
        String projectsKeysString = this.getProjectsKeyString(event.getProjectsKeys());
        return Arrays.asList(AuditAttribute.fromI18nKeys((String)EXPORTED_ISSUES_KEY, (String)issuesTotal).build(), AuditAttribute.fromI18nKeys((String)EXPORTED_FROM_PROJECTS_KEY, (String)projectsKeysString).build());
    }

    private String getProjectsKeyString(List<String> projectsKeys) {
        if (projectsKeys.isEmpty()) {
            I18nHelper i18n = this.i18nFactory.getInstance(Locale.ENGLISH);
            return i18n.getText(ALL_PROJECTS_KEY);
        }
        return String.join((CharSequence)PROJECTS_KEYS_DELIMITER, projectsKeys);
    }
}

