/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.IssueTypeScreenSchemeEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeRemovedFromScreenSchemeEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeAssociateScreenSchemeEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeCreatedEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeDeletedEvent;
import com.atlassian.jira.event.issuetype.screenscheme.IssueTypeScreenSchemeUpdatedEvent;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;

@AuditExceptionSafe
public class IssueTypeScreenSchemeEventHandlerImpl
implements IssueTypeScreenSchemeEventHandler {
    private static final AuditType ISSUE_TYPE_SCREEN_SCHEME_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SCREENS, "jira.auditing.issue.type.screen.scheme.created", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_TYPE_SCREEN_SCHEME_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SCREENS, "jira.auditing.issue.type.screen.scheme.updated", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_TYPE_SCREEN_SCHEME_ASSOCIATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SCREENS, "jira.auditing.issue.type.screen.scheme.associated", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_TYPE_SCREEN_SCHEME_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SCREENS, "jira.auditing.issue.type.screen.scheme.deleted", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_TYPE_SCREEN_SCHEME_REMOVED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SCREENS, "jira.auditing.issue.type.screen.scheme.removed", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public IssueTypeScreenSchemeEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeScreenSchemeCreated(IssueTypeScreenSchemeCreatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_TYPE_SCREEN_SCHEME_CREATED).affectedObject(AuditResource.builder((String)event.getIssueTypeScreenScheme().getName(), (String)AssociatedItem.Type.SCHEME.name()).id(event.getIssueTypeScreenScheme().getId().toString()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.type.screen.scheme.description", event.getIssueTypeScreenScheme().getDescription())).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeScreenSchemeUpdated(IssueTypeScreenSchemeUpdatedEvent event) {
        IssueTypeScreenScheme newScreenScheme = event.getNewIssueTypeScreenScheme();
        IssueTypeScreenScheme previousScreenScheme = event.getIssueTypeScreenScheme();
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_TYPE_SCREEN_SCHEME_UPDATED).changedValues(new ChangedValuesBuilder().addIfDifferent("jira.auditing.issue.type.screen.scheme.name", previousScreenScheme.getName(), newScreenScheme.getName()).addIfDifferent("jira.auditing.issue.type.screen.scheme.description", previousScreenScheme.getDescription(), newScreenScheme.getDescription()).build()).affectedObject(AuditResource.builder((String)newScreenScheme.getName(), (String)AssociatedItem.Type.SCHEME.name()).id(newScreenScheme.getId().toString()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeScreenSchemeDeleted(IssueTypeScreenSchemeDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_TYPE_SCREEN_SCHEME_DELETED).affectedObject(AuditResource.builder((String)event.getIssueTypeScreenScheme().getName(), (String)AssociatedItem.Type.SCHEME.name()).id(event.getIssueTypeScreenScheme().getId().toString()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.type.screen.scheme.description", event.getIssueTypeScreenScheme().getDescription())).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeScreenSchemeAssociateScreenScheme(IssueTypeScreenSchemeAssociateScreenSchemeEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_TYPE_SCREEN_SCHEME_ASSOCIATED).affectedObject(AuditResource.builder((String)event.getIssueTypeScreenScheme().getName(), (String)AssociatedItem.Type.SCHEME.name()).id(event.getIssueTypeScreenScheme().getId().toString()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.type.screen.scheme.description", event.getIssueTypeScreenScheme().getDescription())).changedValues(new ChangedValuesBuilder().add("common.concepts.issuetype", this.getIssueTypeName(event)).add("admin.projects.screen.scheme", event.getFieldScreenScheme().getName()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeScreenSchemeRemovedFromScreen(IssueTypeRemovedFromScreenSchemeEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_TYPE_SCREEN_SCHEME_REMOVED).affectedObject(AuditResource.builder((String)event.getIssueTypeScreenScheme().getName(), (String)AssociatedItem.Type.SCHEME.name()).id(event.getIssueTypeScreenScheme().getId().toString()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.type.screen.scheme.description", event.getIssueTypeScreenScheme().getDescription())).build());
    }

    private String getIssueTypeName(IssueTypeScreenSchemeAssociateScreenSchemeEvent event) {
        return event.getIssueType() != null ? event.getIssueType().getName() : "admin.itss.configure.used.for.all.unmapped.issue.types";
    }
}

