/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.handlers.ProjectRoleHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.UserKeyService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@AuditExceptionSafe
public final class ProjectRoleHandlerImpl
implements ProjectRoleHandler {
    private static final AuditType PROJECT_ROLES_DEFAULT_ACTOR_ADD = AuditEntitiesUtils.newAuditType(CoverageArea.USER_MANAGEMENT, AuditingCategory.PERMISSIONS, "jira.auditing.project.roles.default.actor.add", CoverageLevel.ADVANCED);
    private static final AuditType PROJECT_ROLES_DEFAULT_ACTOR_REMOVE = AuditEntitiesUtils.newAuditType(CoverageArea.USER_MANAGEMENT, AuditingCategory.PERMISSIONS, "jira.auditing.project.roles.default.actor.remove", CoverageLevel.ADVANCED);
    private final UserKeyService userKeyService;
    private final AuditService auditService;

    public ProjectRoleHandlerImpl(UserKeyService userKeyService, AuditService auditService) {
        this.userKeyService = userKeyService;
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleProjectRoleAddActor(Collection<String> usersKey, ProjectRole projectRole) {
        List users = usersKey.stream().map(this::realName).map(user -> AuditEntitiesUtils.newChangedValue("jira.auditing.project.user.or.group", user)).collect(Collectors.toList());
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_ROLES_DEFAULT_ACTOR_ADD).affectedObject(AuditResource.builder((String)projectRole.getName(), (String)AssociatedItem.Type.PROJECT_ROLE.name()).id(projectRole.getId().toString()).build()).changedValues(users).build());
    }

    @Override
    @ThrowSafe
    public void handleProjectRoleRemoveActor(Collection<String> usersKey, ProjectRole projectRole) {
        List users = usersKey.stream().map(this::realName).map(user -> AuditEntitiesUtils.newChangedValue("jira.auditing.project.user.or.group", user, null)).collect(Collectors.toList());
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_ROLES_DEFAULT_ACTOR_REMOVE).affectedObject(AuditResource.builder((String)projectRole.getName(), (String)AssociatedItem.Type.PROJECT_ROLE.name()).id(projectRole.getId().toString()).build()).changedValues(users).build());
    }

    private String realName(String userKey) {
        String name = this.userKeyService.getUsernameForKey(userKey);
        if (name != null) {
            return name;
        }
        return userKey;
    }
}

