/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.handlers.WebsudoAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;

@AuditExceptionSafe
public class WebsudoAuditHandlerImpl
implements WebsudoAuditHandler {
    @VisibleForTesting
    static final AuditType WEBSUDO_SESSION_STARTED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, AuditingCategory.LOGIN, "jira.auditing.websudo.session.started", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType WEBSUDO_SESSION_INVALIDATED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, AuditingCategory.LOGIN, "jira.auditing.websudo.session.invalidated", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType WEBSUDO_WRONG_PASSWORD = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, AuditingCategory.LOGIN, "jira.auditing.websudo.password.wrong", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public WebsudoAuditHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleWebsudoSessionStarted() {
        this.auditService.audit(AuditEvent.builder((AuditType)WEBSUDO_SESSION_STARTED).build());
    }

    @Override
    @ThrowSafe
    public void handleWebsudoSessionInvalidated() {
        this.auditService.audit(AuditEvent.builder((AuditType)WEBSUDO_SESSION_INVALIDATED).build());
    }

    @Override
    @ThrowSafe
    public void handleWebsudoWrongPassword(ApplicationUser user) {
        this.auditService.audit(AuditEvent.builder((AuditType)WEBSUDO_WRONG_PASSWORD).affectedObject(AuditResources.from(user)).build());
    }
}

