/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.migration;

import com.atlassian.audit.api.AuditRetentionConfig;
import com.atlassian.audit.spi.migration.LegacyRetentionConfigProvider;
import com.atlassian.jira.auditing.AuditingRetentionPeriod;
import com.atlassian.jira.config.properties.ApplicationProperties;
import java.time.Period;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditRetentionConfigProviderImpl
implements LegacyRetentionConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(AuditRetentionConfigProviderImpl.class);
    private ApplicationProperties applicationProperties;

    public AuditRetentionConfigProviderImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Optional<AuditRetentionConfig> get() {
        AuditingRetentionPeriod auditingRetentionPeriod = AuditingRetentionPeriod.getByValue(this.applicationProperties.getDefaultBackedString("jira.option.auditing.log.retention.period.in.months"));
        if (auditingRetentionPeriod == null) {
            return Optional.empty();
        }
        Integer auditingRetentionPeriodInt = null;
        switch (auditingRetentionPeriod) {
            case ONE_MONTH: 
            case THREE_MONTHS: 
            case SIX_MONTHS: {
                auditingRetentionPeriodInt = Integer.parseInt(auditingRetentionPeriod.getValue());
                break;
            }
            default: {
                auditingRetentionPeriodInt = 240;
            }
        }
        AuditRetentionConfig auditRetentionConfig = new AuditRetentionConfig(Period.ofMonths(auditingRetentionPeriodInt).normalized());
        log.info("Setting audit log retention period to: {}", (Object)StringUtils.defaultIfEmpty((CharSequence)auditRetentionConfig.getPeriod().toString(), (CharSequence)"default value"));
        return Optional.of(auditRetentionConfig);
    }
}

