/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.migration;

import com.atlassian.jira.auditing.spis.migration.MigrationAuditLog;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.AuditChangedValueDTO;
import com.atlassian.jira.model.querydsl.AuditItemDTO;
import com.atlassian.jira.model.querydsl.AuditLogDTO;
import com.atlassian.jira.model.querydsl.QAuditChangedValue;
import com.atlassian.jira.model.querydsl.QAuditItem;
import com.atlassian.jira.model.querydsl.QAuditLog;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationAuditingDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationAuditingDao.class);
    private final QueryDslAccessor queryDslAccessor;

    public MigrationAuditingDao(@Nonnull QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    @Nonnull
    public List<Long> getAuditLogIds(@Nullable Long limit) {
        LOGGER.debug("getting audit log ids, limit {}", (Object)limit);
        try {
            List list = this.queryDslAccessor.executeQuery(dbConnection -> {
                LOGGER.debug("querying for audit log ids");
                SQLQuery sqlQuery = (SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QAuditLog.AUDIT_LOG.id).from((Expression)QAuditLog.AUDIT_LOG)).orderBy(QAuditLog.AUDIT_LOG.created.desc());
                if (limit != null) {
                    sqlQuery = (SQLQuery)sqlQuery.limit(limit.longValue());
                }
                ArrayList auditLogs = new ArrayList(sqlQuery.fetch());
                LOGGER.debug("querying for audit log ids - limit {}, got: {}", (Object)limit, (Object)auditLogs.size());
                Collections.reverse(auditLogs);
                return auditLogs;
            });
            return list;
        }
        finally {
            LOGGER.debug("getting audit log ids done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuditLogs(Collection<MigrationAuditLog> auditLogs, Collection<Long> convertedAuditLogIds) {
        LOGGER.debug("removing audit logs {}/{}", (Object)convertedAuditLogIds.size(), (Object)auditLogs.size());
        try {
            int auditItemsSize = auditLogs.stream().filter(al -> convertedAuditLogIds.contains(al.getAuditLog().getId())).map(MigrationAuditLog::getAuditItems).mapToInt(Collection::size).sum();
            int changedValuesSize = auditLogs.stream().filter(al -> convertedAuditLogIds.contains(al.getAuditLog().getId())).map(MigrationAuditLog::getChangedValues).mapToInt(Collection::size).sum();
            this.queryDslAccessor.execute(dbConnection -> {
                this.removeChangedValuesDB(dbConnection, convertedAuditLogIds, changedValuesSize);
                this.removeAuditItemsDB(dbConnection, convertedAuditLogIds, auditItemsSize);
                this.removeAuditLogsDB(dbConnection, convertedAuditLogIds);
            });
        }
        finally {
            LOGGER.debug("removed audit logs {}", (Object)auditLogs.size());
        }
    }

    public Collection<MigrationAuditLog> getAuditLogs(List<Long> ids) {
        LOGGER.debug("getting audit logs");
        return (Collection)this.queryDslAccessor.executeQuery(dbConnection -> {
            try {
                ImmutableList.Builder ret = ImmutableList.builder();
                List<AuditLogDTO> auditLogs = this.getAuditLogsDB(dbConnection, ids);
                if (auditLogs.isEmpty()) {
                    ImmutableList immutableList = ret.build();
                    return immutableList;
                }
                List<Long> auditLogIds = auditLogs.stream().map(AuditLogDTO::getId).collect(Collectors.toList());
                List<AuditItemDTO> auditItems = this.getAuditItemsDB(dbConnection, auditLogIds);
                Map<Long, List<AuditItemDTO>> logIdToAuditItems = auditItems.stream().collect(Collectors.groupingBy(AuditItemDTO::getLogId));
                List<AuditChangedValueDTO> changedValues = this.getChangedValuesDB(dbConnection, auditLogIds);
                Map<Long, List<AuditChangedValueDTO>> logIdToAuditChangedValues = changedValues.stream().collect(Collectors.groupingBy(AuditChangedValueDTO::getLogId));
                for (AuditLogDTO auditLog : auditLogs) {
                    ret.add((Object)new MigrationAuditLog(auditLog, logIdToAuditItems.getOrDefault(auditLog.getId(), Collections.emptyList()), logIdToAuditChangedValues.getOrDefault(auditLog.getId(), Collections.emptyList())));
                }
                ImmutableList immutableList = ret.build();
                return immutableList;
            }
            finally {
                LOGGER.debug("getting audit logs done");
            }
        });
    }

    private List<AuditChangedValueDTO> getChangedValuesDB(DbConnection dbConnection, List<Long> auditLogIds) {
        LOGGER.debug("querying for audit changed values");
        List changedValues = ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QAuditChangedValue.AUDIT_CHANGED_VALUE).from((Expression)QAuditChangedValue.AUDIT_CHANGED_VALUE)).where((Predicate)QAuditChangedValue.AUDIT_CHANGED_VALUE.logId.in(auditLogIds))).fetch();
        LOGGER.debug("querying for audit changed values, got: {}", (Object)changedValues.size());
        return changedValues;
    }

    private List<AuditItemDTO> getAuditItemsDB(DbConnection dbConnection, List<Long> auditLogIds) {
        LOGGER.debug("querying for audit items");
        List auditItems = ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QAuditItem.AUDIT_ITEM).from((Expression)QAuditItem.AUDIT_ITEM)).where((Predicate)QAuditItem.AUDIT_ITEM.logId.in(auditLogIds))).fetch();
        LOGGER.debug("querying for audit items, got: {}", (Object)auditItems.size());
        return auditItems;
    }

    private List<AuditLogDTO> getAuditLogsDB(DbConnection dbConnection, List<Long> ids) {
        LOGGER.debug("querying for audit logs");
        List auditLogs = ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QAuditLog.AUDIT_LOG).from((Expression)QAuditLog.AUDIT_LOG)).where((Predicate)QAuditLog.AUDIT_LOG.id.in(ids))).orderBy(QAuditLog.AUDIT_LOG.created.desc())).fetch();
        LOGGER.debug("querying for audit logs, got: {}", (Object)auditLogs.size());
        return auditLogs;
    }

    private void removeAuditLogsDB(DbConnection dbConnection, Collection<Long> auditLogIds) {
        LOGGER.debug("Removing audit logs {}", (Object)auditLogIds.size());
        long removed = dbConnection.delete((RelationalPath<?>)QAuditLog.AUDIT_LOG).where((Predicate)QAuditLog.AUDIT_LOG.id.in(auditLogIds)).execute();
        LOGGER.debug("Removed audit logs {} out of {}", (Object)removed, (Object)auditLogIds.size());
    }

    private void removeAuditItemsDB(DbConnection dbConnection, Collection<Long> auditLogIds, int size) {
        LOGGER.debug("Removing audit items {}", (Object)size);
        long removed = dbConnection.delete((RelationalPath<?>)QAuditItem.AUDIT_ITEM).where((Predicate)QAuditItem.AUDIT_ITEM.logId.in(auditLogIds)).execute();
        LOGGER.debug("Removed audit items {} out of {}", (Object)removed, (Object)size);
    }

    private void removeChangedValuesDB(DbConnection dbConnection, Collection<Long> auditLogIds, int size) {
        LOGGER.debug("Removing changed values {}", (Object)size);
        long removed = dbConnection.delete((RelationalPath<?>)QAuditChangedValue.AUDIT_CHANGED_VALUE).where((Predicate)QAuditChangedValue.AUDIT_CHANGED_VALUE.logId.in(auditLogIds)).execute();
        LOGGER.debug("Removed changed values {} out of {}", (Object)removed, (Object)size);
    }
}

