/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.permission;

import com.atlassian.audit.spi.permission.ResourceContextPermissionChecker;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraResourceContextPermissionCheckerImpl
implements ResourceContextPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(JiraResourceContextPermissionCheckerImpl.class);
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;

    public JiraResourceContextPermissionCheckerImpl(ProjectManager projectManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager) {
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
    }

    public boolean hasResourceAuditViewPermission(@Nonnull String resourceType, @Nonnull String resourceId) {
        if (!"PROJECT".equals(resourceType)) {
            log.warn("Expected resource type PROJECT, received {}", (Object)resourceType);
            return false;
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        Project project = this.findProjectByKeyOrId(resourceId);
        if (user == null || project == null) {
            return false;
        }
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user) && this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user);
    }

    private Project findProjectByKeyOrId(String eitherKeyOrId) {
        try {
            return this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(eitherKeyOrId)));
        }
        catch (NumberFormatException ignored) {
            return this.projectManager.getProjectObjByKey(eitherKeyOrId);
        }
    }
}

