/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.service;

import com.atlassian.audit.core.spi.service.IpAddressProvider;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIpAddressProviderImpl
implements IpAddressProvider {
    private static final Logger log = LoggerFactory.getLogger(JiraIpAddressProviderImpl.class);
    private final HttpContext httpContext;

    public JiraIpAddressProviderImpl(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Nullable
    public String currentIpAddress() {
        return this.remoteIpAddress();
    }

    @Nullable
    public String remoteIpAddress() {
        try {
            return this.forwarderIpAddress().isPresent() ? this.httpContext.getRequest().getHeader("X-Forwarded-For") : this.httpContext.getRequest().getRemoteAddr();
        }
        catch (IllegalStateException | NullPointerException ex) {
            log.debug("Unable to determine remote IP address", (Throwable)ex);
            return null;
        }
    }

    @Nonnull
    public Optional<String> forwarderIpAddress() {
        try {
            return StringUtils.isNotBlank((CharSequence)this.httpContext.getRequest().getHeader("X-Forwarded-For")) ? Optional.ofNullable(this.httpContext.getRequest().getRemoteAddr()) : Optional.empty();
        }
        catch (IllegalStateException | NullPointerException ex) {
            log.debug("Unable to determine forwarder IP address", (Throwable)ex);
            return Optional.empty();
        }
    }
}

