/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.config.util.FileStores;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@ParametersAreNonnullByDefault
public class AvatarTranscoderImpl
implements AvatarTranscoder {
    private static final String PNG_EXTENSION = ".png";
    private final AvatarTagger avatarTagger;
    private final FileStores fileStores;

    public AvatarTranscoderImpl(AvatarTagger avatarTagger, FileStores fileStores) {
        this.avatarTagger = avatarTagger;
        this.fileStores = fileStores;
    }

    @Override
    public FileStore.Path getOrCreateRasterizedAvatarFile(Avatar avatar, Avatar.Size size, InputStream inputStream) throws IOException {
        Preconditions.checkArgument((boolean)avatar.isSystemAvatar(), (Object)"Avatar must be a system avatar");
        return AvatarTranscoderImpl.writeToFileIfEmpty(this.getTranscodedFile(avatar, size), fileOutputStream -> this.transcodeAndTag(inputStream, fileOutputStream, size));
    }

    @Override
    public void transcodeAndTag(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.transcodeAndTag(inputStream, outputStream, Avatar.Size.MEDIUM);
    }

    @Override
    public byte[] transcodeAndTag(String imageKey, InputStream inputStream, Avatar.Size size) throws IOException {
        String filename = this.rasterFileName(this.sanitizeFileName(imageKey), size);
        return (byte[])AvatarTranscoderImpl.writeToFileIfEmpty(this.getFile(filename), outputStream -> this.transcodeAndTag(inputStream, outputStream, size)).fileReader().read(IOUtils::toByteArray);
    }

    private void transcodeAndTag(InputStream inputStream, OutputStream outputStream, Avatar.Size size) throws IOException {
        try {
            TranscoderInput transcoderInput = new TranscoderInput(inputStream);
            ByteArrayOutputStream transcoded = new ByteArrayOutputStream();
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)transcoded);
            PNGTranscoder transcoder = this.newPNGTranscoder(size);
            transcoder.transcode(transcoderInput, transcoderOutput);
            this.avatarTagger.tag(new ByteArrayInputStream(transcoded.toByteArray()), outputStream);
        }
        catch (TranscoderException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    PNGTranscoder createPngTranscoder() {
        return new PNGTranscoder();
    }

    @VisibleForTesting
    FileStore.Path getTranscodedFile(Avatar avatar, Avatar.Size size) {
        return this.getFile(this.rasterAvatarFileName(avatar, size));
    }

    private static <T extends FileStore.Path> T writeToFileIfEmpty(T file, FileStore.OutputStreamWriter fileWriter) throws IOException {
        if (!file.fileExists()) {
            file.fileWriter().write(fileWriter);
        }
        return file;
    }

    private FileStore.Path getFile(String filename) {
        return this.getAvatarBaseDirectory().path(new String[]{filename});
    }

    private FileStore.Path getAvatarBaseDirectory() {
        return this.fileStores.getHomePath().path(new String[]{"data/avatars"});
    }

    private String rasterAvatarFileName(Avatar avatar, Avatar.Size size) {
        return this.rasterFileName(avatar.getFileName(), size);
    }

    private String rasterFileName(String baseFilename, Avatar.Size size) {
        return FilenameUtils.removeExtension((String)(size.param + "_" + baseFilename)) + PNG_EXTENSION;
    }

    private String sanitizeFileName(String imageKey) {
        String forbiddenCharacters = "[^\\w+\\.]";
        return imageKey.replaceAll("^" + forbiddenCharacters + "+", "").replaceAll(forbiddenCharacters, "_");
    }

    private PNGTranscoder newPNGTranscoder(Avatar.Size size) {
        PNGTranscoder transcoder = this.createPngTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(size.getPixels()));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(size.getPixels()));
        return transcoder;
    }
}

