/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.customfield;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class CustomFieldViewUtils {
    private static final String ASCENDING_ORDER = "ascending";
    private static final String DESCENDING_ORDER = "descending";
    private static final String LAST_VALUE_UPDATE_COLUMN = "lastValueUpdate";
    private static final String ISSUES_WITH_VALUE_COLUMN = "issuesWithValue";
    private static final Long NEVER_UPDATED = -1L;

    private CustomFieldViewUtils() {
    }

    static List<CustomField> sortCustomFields(List<CustomField> customFields, String sortOrder, String sortColumn, Predicate<CustomField> isTrustedPredicate) {
        Preconditions.checkNotNull(customFields);
        Preconditions.checkNotNull((Object)sortOrder);
        Preconditions.checkNotNull((Object)sortColumn);
        Comparator<CustomField> comparator = CustomFieldViewUtils.getComparator(sortColumn, sortOrder, isTrustedPredicate);
        if (comparator != null) {
            return customFields.stream().sorted(comparator).collect(Collectors.toList());
        }
        return customFields;
    }

    static List<CustomField> filterCustomFieldsByLastValueUpdate(List<CustomField> customFields, Long lastValueUpdate) {
        Preconditions.checkNotNull(customFields);
        Preconditions.checkNotNull((Object)lastValueUpdate);
        if (lastValueUpdate.equals(NEVER_UPDATED)) {
            return customFields.stream().filter(cf -> cf.getLastValueUpdate() == null).collect(Collectors.toList());
        }
        return customFields.stream().filter(cf -> cf.getLastValueUpdate() != null).filter(cf -> cf.getLastValueUpdate().before(new Timestamp(lastValueUpdate))).collect(Collectors.toList());
    }

    private static Comparator<CustomField> getComparator(String sortColumn, String sortOrder, Predicate<CustomField> isTrustedPredicate) {
        if (sortColumn.equals(LAST_VALUE_UPDATE_COLUMN)) {
            if (sortOrder.equals(ASCENDING_ORDER)) {
                return new LastValueUpdateComparator(Comparator.comparing(CustomField::getLastValueUpdate, Comparator.nullsFirst(Comparator.naturalOrder())), isTrustedPredicate).thenComparing(Field::getName);
            }
            if (sortOrder.equals(DESCENDING_ORDER)) {
                return new LastValueUpdateComparator(Comparator.comparing(CustomField::getLastValueUpdate, Comparator.nullsLast(Comparator.reverseOrder())), isTrustedPredicate).thenComparing(Field::getName);
            }
        }
        if (sortColumn.equals(ISSUES_WITH_VALUE_COLUMN)) {
            if (sortOrder.equals(ASCENDING_ORDER)) {
                return new IssueComparator(Comparator.comparing(CustomField::getIssuesWithValue, Comparator.naturalOrder()), isTrustedPredicate).thenComparing(Field::getName);
            }
            if (sortOrder.equals(DESCENDING_ORDER)) {
                return new IssueComparator(Comparator.comparing(CustomField::getIssuesWithValue, Comparator.reverseOrder()), isTrustedPredicate).thenComparing(Field::getName);
            }
        }
        return null;
    }

    static final class LastValueUpdateComparator
    extends ComparatorForUsage {
        LastValueUpdateComparator(Comparator<CustomField> comparator, Predicate<CustomField> isTrustedPredicate) {
            super(comparator, isTrustedPredicate);
        }

        @Override
        public int compare(CustomField cf1, CustomField cf2) {
            if (this.isNullAndUntrusted(cf1)) {
                return this.isNullAndUntrusted(cf2) ? 0 : 1;
            }
            if (this.isNullAndUntrusted(cf2)) {
                return -1;
            }
            return this.comparator.compare(cf1, cf2);
        }

        private boolean isNullAndUntrusted(CustomField cf) {
            return cf.getLastValueUpdate() == null && this.isUntrusted(cf);
        }
    }

    static final class IssueComparator
    extends ComparatorForUsage {
        IssueComparator(Comparator<CustomField> comparator, Predicate<CustomField> isTrustedPredicate) {
            super(comparator, isTrustedPredicate);
        }

        @Override
        public int compare(CustomField cf1, CustomField cf2) {
            if (this.isNullOrUntrusted(cf1)) {
                return this.isNullOrUntrusted(cf2) ? 0 : 1;
            }
            if (this.isNullOrUntrusted(cf2)) {
                return -1;
            }
            return this.comparator.compare(cf1, cf2);
        }

        private boolean isNullOrUntrusted(CustomField cf) {
            return cf.getIssuesWithValue() == null || cf.getIssuesWithValue() == 0L && this.isUntrusted(cf);
        }
    }

    static abstract class ComparatorForUsage
    implements Comparator<CustomField> {
        protected final Comparator<CustomField> comparator;
        protected final Predicate<CustomField> isTrustedPredicate;

        ComparatorForUsage(Comparator<CustomField> comparator, Predicate<CustomField> isTrustedPredicate) {
            this.comparator = comparator;
            this.isTrustedPredicate = isTrustedPredicate;
        }

        protected boolean isUntrusted(CustomField cf) {
            return !this.isTrustedPredicate.test(cf);
        }
    }
}

