/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.customfield;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.customfield.CreateValidationResult;
import com.atlassian.jira.bc.customfield.CustomFieldDefinition;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.bc.customfield.CustomFieldViewUtils;
import com.atlassian.jira.bc.customfield.CustomFieldVisibilityCheck;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.usage.CustomFieldUsageUtil;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ofbiz.GenericValueUtils;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextConfigHelper;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldValidator;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultCustomFieldService
implements CustomFieldService {
    public static final String GLOBAL_CONTEXT_TEXT = "admin.issuefields.customfields.global.all.projects";
    private static final String CUSTOMFIELD_PREFIX = "customfield_";
    private static final String NONE_VALUE = "-1";
    private final GlobalPermissionManager permissionManager;
    private final CustomFieldManager customFieldManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final CustomFieldValidator customFieldValidator;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ProjectManager projectManager;
    private final CustomFieldContextConfigHelper customFieldContextConfigHelper;
    private final ReindexMessageManager reindexMessageManager;
    private final ConstantsManager constantManager;
    private final FieldScreenManager fieldScreenManager;
    private final LocaleManager localeManager;
    private final TranslationManager translationManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final CustomFieldVisibilityCheck customFieldVisibilityCheck;

    public DefaultCustomFieldService(GlobalPermissionManager permissionManager, CustomFieldManager customFieldManager, PermissionSchemeManager permissionSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, CustomFieldValidator customFieldValidator, I18nHelper.BeanFactory i18nFactory, ProjectManager projectManager, CustomFieldContextConfigHelper customFieldContextConfigHelper, ReindexMessageManager reindexMessageManager, ConstantsManager constantManager, FieldScreenManager fieldScreenManager, LocaleManager localeManager, TranslationManager translationManager, ManagedConfigurationItemService managedConfigurationItemService, CustomFieldVisibilityCheck customFieldVisibilityCheck) {
        this.permissionManager = permissionManager;
        this.customFieldManager = customFieldManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.customFieldValidator = customFieldValidator;
        this.i18nFactory = i18nFactory;
        this.projectManager = projectManager;
        this.customFieldContextConfigHelper = customFieldContextConfigHelper;
        this.reindexMessageManager = reindexMessageManager;
        this.constantManager = constantManager;
        this.fieldScreenManager = fieldScreenManager;
        this.localeManager = localeManager;
        this.translationManager = translationManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.customFieldVisibilityCheck = customFieldVisibilityCheck;
    }

    public ServiceOutcome<CustomField> getCustomFieldForEditConfig(@Nullable ApplicationUser user, String fieldId) {
        Preconditions.checkArgument((fieldId != null ? 1 : 0) != 0, (Object)"fieldId is null.");
        if (!this.permissionManager.hasPermission(0, user)) {
            return ServiceOutcomeImpl.error(this.i18n(user).getText("admin.customfields.service.no.admin.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        CustomField customFieldObject = this.customFieldManager.getCustomFieldObject(fieldId);
        if (customFieldObject != null) {
            ManagedConfigurationItem managedCustomField = this.managedConfigurationItemService.getManagedCustomField(customFieldObject);
            if (this.managedConfigurationItemService.doesUserHavePermission(user, managedCustomField)) {
                return ServiceOutcomeImpl.ok(customFieldObject);
            }
            String message = this.i18n(user).getText("admin.managed.configuration.items.customfield.error.cannot.alter.configuration.locked", fieldId);
            return ServiceOutcomeImpl.error(message, ErrorCollection.Reason.FORBIDDEN);
        }
        return ServiceOutcomeImpl.error(this.i18n(user).getText("admin.errors.customfields.invalid.custom.field"), ErrorCollection.Reason.NOT_FOUND);
    }

    @Nonnull
    public Iterable<CustomFieldType<?, ?>> getCustomFieldTypesForUser(final ApplicationUser user) {
        if (!this.permissionManager.hasPermission(0, user)) {
            return Collections.emptyList();
        }
        List customFieldTypes = this.customFieldManager.getCustomFieldTypes();
        return Iterables.unmodifiableIterable((Iterable)Iterables.filter((Iterable)customFieldTypes, (Predicate)new Predicate<CustomFieldType<?, ?>>(){

            public boolean apply(CustomFieldType<?, ?> input) {
                ConfigurationItemAccessLevel managedAccessLevel = input.getDescriptor().getManagedAccessLevel();
                return managedAccessLevel == null || DefaultCustomFieldService.this.managedConfigurationItemService.doesUserHavePermission(user, managedAccessLevel);
            }
        }));
    }

    @Nullable
    public CustomFieldSearcher getDefaultSearcher(@Nonnull CustomFieldType<?, ?> type) {
        return this.customFieldManager.getDefaultSearcher(type);
    }

    public void validateDelete(JiraServiceContext jiraServiceContext, Long customFieldId) {
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInApplicationUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return;
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.custom.field"));
            return;
        }
        this.validateNotUsedInPermissionSchemes(jiraServiceContext, customFieldId, false);
    }

    public void validateUpdate(JiraServiceContext jiraServiceContext, Long customFieldId, String name, String description, String searcherKey) {
        if (customFieldId == null) {
            throw new IllegalArgumentException("customFieldId can not be null.");
        }
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInApplicationUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return;
        }
        CustomField originalCustomField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (originalCustomField == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.custom.field"));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            jiraServiceContext.getErrorCollection().addError("name", i18nBean.getText("admin.errors.customfields.no.name"));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)searcherKey) && !NONE_VALUE.equals(searcherKey) && this.customFieldManager.getCustomFieldSearcher(searcherKey) == null) {
            jiraServiceContext.getErrorCollection().addError("searcher", i18nBean.getText("admin.errors.customfields.invalid.searcher"));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)searcherKey) || NONE_VALUE.equals(searcherKey)) {
            this.validateNotUsedInPermissionSchemes(jiraServiceContext, customFieldId, true);
        }
    }

    public void validateTranslation(JiraServiceContext jiraServiceContext, Long customFieldId, String name, String description, String locale) {
        if (customFieldId == null) {
            throw new IllegalArgumentException("customFieldId can not be null.");
        }
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        if (!this.permissionManager.hasPermission(0, jiraServiceContext.getLoggedInApplicationUser())) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return;
        }
        CustomField originalCustomField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (originalCustomField == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.custom.field"));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)locale) || this.localeManager.getLocale(locale) == null) {
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.locale"));
        }
    }

    public void updateTranslation(JiraServiceContext jiraServiceContext, Long customFieldId, String name, String description, String localeString) {
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (StringUtils.isEmpty((CharSequence)localeString) || this.localeManager.getLocale(localeString) == null) {
            I18nHelper i18nBean = jiraServiceContext.getI18nBean();
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.errors.customfields.invalid.locale"));
        }
        Locale locale = this.localeManager.getLocale(localeString);
        this.translationManager.setCustomFieldTranslation(customField, locale, name, description);
    }

    void validateNotUsedInPermissionSchemes(JiraServiceContext jiraServiceContext, Long customFieldId, boolean forUpdate) {
        Set<GenericValue> usedIssueLevelSecuritySchemes;
        I18nHelper i18nBean = jiraServiceContext.getI18nBean();
        Set<GenericValue> usedPermissionSchemes = this.getUsedPermissionSchemes(customFieldId);
        if (!usedPermissionSchemes.isEmpty()) {
            String messageKey = forUpdate ? "admin.errors.customfields.used.in.permission.scheme.update" : "admin.errors.customfields.used.in.permission.scheme.delete";
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText(messageKey, GenericValueUtils.getCommaSeparatedList(usedPermissionSchemes, (String)"name")));
        }
        if (!(usedIssueLevelSecuritySchemes = this.getUsedIssueSecuritySchemes(customFieldId)).isEmpty()) {
            String messageKey = forUpdate ? "admin.errors.customfields.used.in.issuelevelschemes.update" : "admin.errors.customfields.used.in.issuelevelschemes.delete";
            jiraServiceContext.getErrorCollection().addErrorMessage(i18nBean.getText(messageKey, GenericValueUtils.getCommaSeparatedList(usedIssueLevelSecuritySchemes, (String)"name")));
        }
    }

    public ServiceOutcome<CreateValidationResult> validateCreate(ApplicationUser user, CustomFieldDefinition customFieldDefinition) {
        List returnIssueTypes;
        CustomFieldSearcher searcher;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        if (user == null || !this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return new ServiceOutcomeImpl<Object>((ErrorCollection)errorCollection, null);
        }
        if (StringUtils.isBlank((CharSequence)customFieldDefinition.getCfType())) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.customfields.no.field.type.specified"));
            return new ServiceOutcomeImpl<Object>((ErrorCollection)errorCollection, null);
        }
        errorCollection.addErrorCollection(this.customFieldValidator.validateType(customFieldDefinition.getCfType()));
        if (errorCollection.hasAnyErrors()) {
            return new ServiceOutcomeImpl<Object>((ErrorCollection)errorCollection, null);
        }
        CustomFieldType customFieldType = this.customFieldManager.getCustomFieldType(customFieldDefinition.getCfType());
        String searcherKey = customFieldDefinition.isUseDefaultSearcher() ? ((searcher = this.customFieldManager.getDefaultSearcher(customFieldType)) == null ? null : searcher.getDescriptor().getCompleteKey()) : customFieldDefinition.getSearcherKey();
        errorCollection.addErrorCollection(this.customFieldValidator.validateDetails(customFieldDefinition.getName(), customFieldDefinition.getCfType(), searcherKey));
        if (errorCollection.hasAnyErrors()) {
            return new ServiceOutcomeImpl<Object>((ErrorCollection)errorCollection, null);
        }
        if (!customFieldDefinition.isGlobal() && customFieldDefinition.getProjectIds().isEmpty()) {
            errorCollection.addError("projects", i18nBean.getText("admin.errors.must.select.project.for.non.global.contexts"));
            return new ServiceOutcomeImpl<Object>((ErrorCollection)errorCollection, null);
        }
        List projects = customFieldDefinition.getProjectIds();
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)customFieldDefinition.isGlobal(), (Long[])projects.toArray(new Long[projects.size()]), (ProjectManager)this.projectManager);
        if (customFieldDefinition.isAllIssueTypes()) {
            returnIssueTypes = Lists.newArrayList();
            returnIssueTypes.add(null);
        } else {
            List issueTypesIds = customFieldDefinition.getIssueTypeIds();
            returnIssueTypes = CustomFieldUtils.buildIssueTypes((ConstantsManager)this.constantManager, (String[])issueTypesIds.toArray(new String[issueTypesIds.size()]));
        }
        CustomFieldSearcher customFieldSearcher = this.customFieldManager.getCustomFieldSearcher(searcherKey);
        CreateValidationResult createValidationResult = CreateValidationResult.builder().user(user).customFieldType(customFieldType).name(customFieldDefinition.getName()).description(customFieldDefinition.getDescription()).customFieldSearcher(customFieldSearcher).contextNodes(contexts).issueTypes(returnIssueTypes).build();
        return new ServiceOutcomeImpl<CreateValidationResult>((ErrorCollection)errorCollection, createValidationResult);
    }

    public ServiceOutcome<CustomField> create(CreateValidationResult createValidationResult) {
        CustomField customField;
        try {
            customField = this.customFieldManager.createCustomField(createValidationResult.getName(), createValidationResult.getDescription(), createValidationResult.getCustomFieldType(), createValidationResult.getCustomFieldSearcher(), createValidationResult.getContextNodes(), createValidationResult.getIssueTypes());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        if (this.customFieldContextConfigHelper.doesAddingContextToCustomFieldAffectIssues(createValidationResult.getUser(), customField, createValidationResult.getContextNodes(), createValidationResult.getIssueTypes(), true)) {
            this.reindexMessageManager.pushMessage(createValidationResult.getUser(), "admin.notifications.task.custom.fields");
        }
        return ServiceOutcomeImpl.ok(customField);
    }

    public ServiceOutcomeImpl<List<Long>> addToScreenTabs(ApplicationUser user, Long customFieldId, List<Long> tabIds) {
        Preconditions.checkArgument((customFieldId != null ? 1 : 0) != 0, (Object)"customFieldId can not be null.");
        Preconditions.checkArgument((tabIds != null && !tabIds.isEmpty() ? 1 : 0) != 0, (Object)"List of tabs can not be null or empty.");
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        if (user == null || !this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return new ServiceOutcomeImpl<List<Long>>((ErrorCollection)errorCollection, Collections.emptyList());
        }
        for (Long screenId : tabIds) {
            String customFieldKey;
            FieldScreenTab fieldScreenTab = this.fieldScreenManager.getFieldScreenTab(screenId);
            if (!fieldScreenTab.isContainsField(customFieldKey = CUSTOMFIELD_PREFIX + customFieldId)) {
                fieldScreenTab.addFieldScreenLayoutItem(customFieldKey);
                continue;
            }
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.field.with.id.already.exists", customFieldKey));
            return new ServiceOutcomeImpl<List<Long>>((ErrorCollection)errorCollection, this.getListOfCurrentTabs(customFieldId));
        }
        return new ServiceOutcomeImpl<List<Long>>((ErrorCollection)errorCollection, this.getListOfCurrentTabs(customFieldId));
    }

    public ServiceOutcomeImpl<List<Long>> removeFromScreenTabs(ApplicationUser user, Long customFieldId, List<Long> tabIds) {
        Preconditions.checkArgument((customFieldId != null ? 1 : 0) != 0, (Object)"customFieldId can not be null.");
        Preconditions.checkArgument((tabIds != null && !tabIds.isEmpty() ? 1 : 0) != 0, (Object)"List of tabs can not be null or empty.");
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        if (user == null || !this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"));
            return new ServiceOutcomeImpl<List<Long>>((ErrorCollection)errorCollection, Collections.emptyList());
        }
        for (Long screenId : tabIds) {
            FieldScreenTab fieldScreenTab = this.fieldScreenManager.getFieldScreenTab(screenId);
            fieldScreenTab.getFieldScreen().removeFieldScreenLayoutItem(CUSTOMFIELD_PREFIX + customFieldId);
        }
        return new ServiceOutcomeImpl<List<Long>>((ErrorCollection)errorCollection, this.getListOfCurrentTabs(customFieldId));
    }

    @VisibleForTesting
    Set<GenericValue> getUsedPermissionSchemes(Long customFieldId) {
        HashSet<GenericValue> ret = new HashSet<GenericValue>();
        ret.addAll(this.permissionSchemeManager.getSchemesContainingEntity("userCF", CUSTOMFIELD_PREFIX + customFieldId));
        ret.addAll(this.permissionSchemeManager.getSchemesContainingEntity("groupCF", CUSTOMFIELD_PREFIX + customFieldId));
        return ret;
    }

    @VisibleForTesting
    Set<GenericValue> getUsedIssueSecuritySchemes(Long customFieldId) {
        HashSet<GenericValue> ret = new HashSet<GenericValue>();
        ret.addAll(this.issueSecuritySchemeManager.getSchemesContainingEntity("userCF", CUSTOMFIELD_PREFIX + customFieldId));
        ret.addAll(this.issueSecuritySchemeManager.getSchemesContainingEntity("groupCF", CUSTOMFIELD_PREFIX + customFieldId));
        return ret;
    }

    private List<Long> getListOfCurrentTabs(Long customFieldId) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.fieldScreenManager.getFieldScreenTabs(CUSTOMFIELD_PREFIX + customFieldId), (Function)new Function<FieldScreenTab, Long>(){

            public Long apply(FieldScreenTab input) {
                return input.getId();
            }
        }));
    }

    private I18nHelper i18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    public ServiceOutcomeImpl<List<CustomField>> findCustomFields(ApplicationUser user, @Nullable String searchString, @Nullable List<String> types, @Nullable List<String> projects, @Nullable List<String> screens, @Nullable String sortOrder, @Nullable String sortColumn, @Nullable Long lastValueUpdate) {
        Objects.requireNonNull(user);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.i18n(user);
        if (!this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.customfields.service.no.admin.permission"), ErrorCollection.Reason.FORBIDDEN);
            return new ServiceOutcomeImpl<List<CustomField>>((ErrorCollection)errorCollection, Collections.emptyList());
        }
        Stream<Object> customFields = this.customFieldManager.getCustomFieldObjects().stream();
        if (StringUtils.isNotBlank((CharSequence)searchString)) {
            customFields = customFields.filter(cf -> this.isSearchStringMatch((CustomField)cf, searchString));
        }
        if (types != null && !types.isEmpty()) {
            Set typeKeys = types.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            customFields = customFields.filter(cf -> this.isTypeMatch((CustomField)cf, typeKeys));
        }
        if (projects != null && !projects.isEmpty()) {
            boolean isGlobalContextSearch = projects.contains(GLOBAL_CONTEXT_TEXT);
            Set projectIds = this.getLongStream(projects).collect(Collectors.toSet());
            customFields = customFields.filter(cf -> this.isProjectMatch((CustomField)cf, projectIds, isGlobalContextSearch));
        }
        if (screens != null && !screens.isEmpty()) {
            List screenFields = this.getLongStream(screens).map(arg_0 -> ((FieldScreenManager)this.fieldScreenManager).getFieldScreen(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            if (!screenFields.isEmpty()) {
                customFields = customFields.filter(cf -> this.isScreenMatch((CustomField)cf, screenFields));
            }
        }
        List<CustomField> returnedCustomFields = customFields.collect(Collectors.toList());
        if (lastValueUpdate != null) {
            returnedCustomFields = CustomFieldViewUtils.filterCustomFieldsByLastValueUpdate(returnedCustomFields, lastValueUpdate);
        }
        if (sortOrder != null && sortColumn != null) {
            returnedCustomFields = CustomFieldViewUtils.sortCustomFields(returnedCustomFields, sortOrder, sortColumn, ((CustomFieldUsageUtil)ComponentAccessor.getComponent(CustomFieldUsageUtil.class))::isValueStorageTrusted);
        }
        return new ServiceOutcomeImpl<List<CustomField>>((ErrorCollection)errorCollection, returnedCustomFields);
    }

    public ServiceOutcome<CustomField> getCustomField(@Nullable ApplicationUser user, @Nonnull Long fieldId) {
        CustomField field = this.customFieldManager.getCustomFieldObject(fieldId);
        if (field != null && this.customFieldVisibilityCheck.isCustomFieldVisibleForUser(user, field)) {
            return ServiceOutcomeImpl.ok(field);
        }
        return ServiceOutcomeImpl.error(this.i18n(user).getText("customfields.service.field.does.not.exist.or.no.permission", String.valueOf(fieldId)), ErrorCollection.Reason.NOT_FOUND);
    }

    private Stream<Long> getLongStream(@Nonnull List<String> list) {
        return list.stream().filter(StringUtils::isNotBlank).filter(StringUtils::isNumeric).map(Long::valueOf);
    }

    private boolean isTypeMatch(CustomField cf, Set<String> typeKeys) {
        if (typeKeys.isEmpty()) {
            return true;
        }
        return typeKeys.contains(cf.getCustomFieldType().getKey());
    }

    private boolean isSearchStringMatch(CustomField cf, @Nullable String searchString) {
        return StringUtils.containsIgnoreCase((CharSequence)cf.getUntranslatedName(), (CharSequence)searchString) || StringUtils.containsIgnoreCase((CharSequence)cf.getFieldName(), (CharSequence)searchString) || StringUtils.containsIgnoreCase((CharSequence)cf.getDescription(), (CharSequence)searchString) || StringUtils.containsIgnoreCase((CharSequence)cf.getUntranslatedDescription(), (CharSequence)searchString);
    }

    private boolean isProjectMatch(CustomField cf, Set<Long> projectIds, boolean isGlobalContextSearch) {
        if (projectIds.isEmpty() && !isGlobalContextSearch) {
            return true;
        }
        if (projectIds.isEmpty() && isGlobalContextSearch) {
            return cf.isGlobal() || cf.isAllProjects();
        }
        if (isGlobalContextSearch && (cf.isGlobal() || cf.isAllProjects())) {
            return true;
        }
        return cf.getAssociatedProjectObjects().stream().filter(Objects::nonNull).map(Project::getId).anyMatch(projectIds::contains);
    }

    private boolean isScreenMatch(CustomField cf, List<FieldScreen> fieldScreens) {
        return fieldScreens.stream().anyMatch(fieldScreen -> fieldScreen.containsField(cf.getId()));
    }
}

