/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.jira.bc.dataimport.DataImportOSPropertyValidator;
import com.atlassian.jira.bc.dataimport.OfbizImportHandler;
import java.util.Optional;

class DataImportPropertiesAdapter
implements DataImportOSPropertyValidator.DataImportProperties {
    private final OfbizImportHandler ofbizImportHandler;

    DataImportPropertiesAdapter(OfbizImportHandler ofbizImportHandler) {
        this.ofbizImportHandler = ofbizImportHandler;
    }

    public Optional<String> getStringProperty(String propertyKey) {
        return this.getId(propertyKey).map(id -> this.ofbizImportHandler.getOsPropertyStringMap().get(id));
    }

    public Optional<String> getTextProperty(String propertyKey) {
        return this.getId(propertyKey).map(id -> this.ofbizImportHandler.getOsPropertyTextMap().get(id));
    }

    public Optional<Long> getNumberProperty(String propertyKey) {
        return this.getId(propertyKey).map(id -> this.ofbizImportHandler.getOsPropertyNumberMap().get(id)).map(Long::parseLong);
    }

    private Optional<String> getId(String propertyKey) {
        return Optional.ofNullable(this.ofbizImportHandler.getPropertyKeyToId().get(propertyKey));
    }
}

