/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.analytics.api.annotations.PrivacyPolicySafe;

@PrivacyPolicySafe
public class WorkflowManualTransitionExecutionEvent {
    private static final String BASE_EVENT_NAME = "workflow.manual.issue.transition.execution";
    @PrivacyPolicySafe(value=true)
    private final int actionId;
    @PrivacyPolicySafe(value=true)
    private final Long issueId;
    @PrivacyPolicySafe(value=true)
    private final Long projectId;
    @PrivacyPolicySafe(value=true)
    private final String issueTypeId;
    @PrivacyPolicySafe(value=true)
    private final String projectTypeId;
    private final boolean successful;

    public WorkflowManualTransitionExecutionEvent(int actionId, Long issueId, Long projectId, String issueTypeId, String projectTypeId, boolean successful) {
        this.actionId = actionId;
        this.issueId = issueId;
        this.projectId = projectId;
        this.projectTypeId = projectTypeId;
        this.issueTypeId = issueTypeId;
        this.successful = successful;
    }

    public int getActionId() {
        return this.actionId;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public String getProjectTypeId() {
        return this.projectTypeId;
    }

    @EventName
    public String buildEventName() {
        return String.format("%s.%s", BASE_EVENT_NAME, this.successful ? "successful" : "failed");
    }
}

