/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.license;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.bc.license.LicenseValidationInfo;
import com.atlassian.jira.bc.license.RawProductLicenseImpl;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseValidationInformation;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.validate.LicenseErrorCode;
import com.atlassian.sal.api.validate.LicenseValidationError;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class JiraLicenseServiceImpl
implements JiraLicenseUpdaterService {
    private static final int MIN_LICENSE_VERSION = 2;
    private static final String INVALID_PRODUCT_KEY = "jira.license.validation.invalid.product.key";
    private static final String INVALID_LICENSE_KEY = "jira.license.validation.invalid.license.key";
    private final JiraLicenseManager licenseManager;
    private final ClusterManager clusterManager;
    private final ApplicationManager applicationManager;
    private final UserManager userManager;
    private final HelpUrls helpUrls;

    public JiraLicenseServiceImpl(@Nonnull JiraLicenseManager licenseManager, @Nonnull ClusterManager clusterManager, @Nonnull ApplicationManager applicationManager, @Nonnull UserManager userManager, @Nonnull HelpUrls helpUrls) {
        this.helpUrls = helpUrls;
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"licenseManager", (Object)licenseManager);
        this.clusterManager = (ClusterManager)Assertions.notNull((String)"clusterManager", (Object)clusterManager);
        this.applicationManager = (ApplicationManager)Assertions.notNull((String)"applicationManager", (Object)applicationManager);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
    }

    @Nonnull
    public String getServerId() {
        return this.licenseManager.getServerId();
    }

    public JiraLicenseService.ValidationResult validate(@Nonnull I18nHelper i18nHelper, @Nonnull String licenseString) {
        LicenseValidationHelper helper = new LicenseValidationHelper(i18nHelper, this.helpUrls);
        Either errorOrLicenseDetails = helper.decodeLicenseDetails(licenseString, this.licenseManager).flatMap(helper.validateLicenseTypeAndVersion(this.isDataCenterConfigured(), 2));
        int totalUserCount = this.userManager.getTotalUserCount();
        if (errorOrLicenseDetails.isLeft()) {
            OurValidationResult validationResult = new OurValidationResult(totalUserCount, licenseString, null);
            validationResult.addError(((LicenseValidationError)errorOrLicenseDetails.left().get()).getErrorMessage());
            return validationResult;
        }
        return new OurValidationResult(totalUserCount, licenseString, (LicenseDetails)errorOrLicenseDetails.right().get());
    }

    public JiraLicenseService.ValidationResult validate(@Nonnull ApplicationKey applicationKey, @Nonnull String licenseString, @Nonnull I18nHelper i18nHelper) {
        if (applicationKey == null) {
            return new OurValidationResult(this.userManager.getTotalUserCount(), licenseString, null, i18nHelper.getText(INVALID_PRODUCT_KEY));
        }
        Optional<LicenseDetails> licenseDetail = this.getLicenseDetails(licenseString, i18nHelper);
        if (!licenseDetail.isPresent()) {
            return new OurValidationResult(this.userManager.getTotalUserCount(), licenseString, null, i18nHelper.getText(INVALID_LICENSE_KEY));
        }
        LicenseValidationInfo licenseValidationInformation = new LicenseValidationInfo(new RawProductLicenseImpl(Optional.ofNullable(applicationKey.value()), Optional.ofNullable(licenseString)), licenseDetail);
        Collection<LicenseValidationInformation> validationResults = this.validateMultiLicenses(Sets.newHashSet((Object[])new LicenseValidationInformation[]{licenseValidationInformation}), i18nHelper);
        return validationResults.stream().map(license -> license.getLicenseValidationResult()).flatMap(license -> license.getErrorMessages().stream()).map(error -> this.convertResult((LicenseValidationError)error, licenseString)).findFirst().orElse(new OurValidationResult(this.userManager.getTotalUserCount(), licenseString));
    }

    public Collection<LicenseValidationInformation> validateMultiLicenses(@Nonnull Collection<LicenseValidationInformation> licenseValidationInformations, @Nonnull I18nHelper i18nHelper) {
        Set noNeedMoreValidationLicenses = licenseValidationInformations.stream().filter(license -> !license.needMoreValidation()).collect(Collectors.toSet());
        Set needsToValidLicenses = licenseValidationInformations.stream().filter(license -> license.needMoreValidation()).collect(Collectors.toSet());
        Set<LicenseValidationInformation> errorLicenses = needsToValidLicenses.stream().map(license -> this.validateLicenseDetail((LicenseValidationInformation)license, i18nHelper)).collect(Collectors.toSet());
        Set<LicenseValidationInformation> compatibilityValidateResult = this.validateHostingTypeCompatibility(errorLicenses, i18nHelper);
        return Stream.concat(noNeedMoreValidationLicenses.stream(), compatibilityValidateResult.stream()).collect(Collectors.toSet());
    }

    public Optional<LicenseDetails> getLicenseDetails(@Nullable String licenseString, @Nonnull I18nHelper i18nHelper) {
        LicenseValidationHelper helper = new LicenseValidationHelper(i18nHelper, this.helpUrls);
        return helper.getLicenseDetails(licenseString, this.licenseManager);
    }

    @Deprecated
    public JiraLicenseService.ValidationResult validateApplicationLicense(@Nonnull I18nHelper i18nHelper, @Nonnull String licenseString) {
        HashSet appKeys = Sets.newHashSet();
        for (Application application : this.applicationManager.getApplications()) {
            appKeys.add(application.getKey());
        }
        if (appKeys.isEmpty()) {
            return new OurValidationResult(this.userManager.getTotalUserCount(), licenseString, null, i18nHelper.getText(INVALID_PRODUCT_KEY));
        }
        Set errors = appKeys.stream().map(appKey -> this.validate((ApplicationKey)appKey, licenseString, i18nHelper)).collect(Collectors.toSet());
        OurValidationResult res = new OurValidationResult(this.userManager.getTotalUserCount(), licenseString);
        errors.stream().flatMap(error -> error.getErrorCollection().getErrors().values().stream().distinct()).forEach(x$0 -> res.addError(x$0));
        return res;
    }

    public SortedSet<String> getSupportEntitlementNumbers() {
        return this.licenseManager.getSupportEntitlementNumbers();
    }

    @Nonnull
    public Iterable<JiraLicenseService.ValidationResult> validate(I18nHelper i18nHelper) {
        ArrayList<JiraLicenseService.ValidationResult> results = new ArrayList<JiraLicenseService.ValidationResult>();
        for (LicenseDetails license : this.getLicenses()) {
            results.add(this.validate(i18nHelper, license.getLicenseString()));
        }
        return results;
    }

    private boolean isDataCenterConfigured() {
        return this.clusterManager.isClustered();
    }

    public Iterable<JiraLicenseService.ValidationResult> validate(I18nHelper i18n, Iterable<String> licenses) {
        if (Iterables.isEmpty(licenses)) {
            OurValidationResult validationResult = new OurValidationResult(this.userManager.getTotalUserCount(), null, null, i18n.getText("admin.errors.no.license.supplied"));
            return Lists.newArrayList((Object[])new JiraLicenseService.ValidationResult[]{validationResult});
        }
        ArrayList<JiraLicenseService.ValidationResult> results = new ArrayList<JiraLicenseService.ValidationResult>(Iterables.size(licenses));
        for (String license : licenses) {
            results.add(this.validate(i18n, license));
        }
        return results;
    }

    public boolean isLicenseSet() {
        return this.licenseManager.isLicenseSet();
    }

    public boolean isDataCenterLicensed() {
        return this.clusterManager.isClusterLicensed();
    }

    public LicenseDetails setLicense(JiraLicenseService.ValidationResult validationResult) {
        if (validationResult == null || validationResult.getErrorCollection() == null || validationResult.getErrorCollection().hasAnyErrors()) {
            throw new IllegalStateException("setLicense called with illegal ValidationResult object");
        }
        return this.licenseManager.setLicense(validationResult.getLicenseString());
    }

    public LicenseDetails setLicenseNoEvent(JiraLicenseService.ValidationResult validationResult) {
        if (validationResult == null || validationResult.getErrorCollection() == null || validationResult.getErrorCollection().hasAnyErrors()) {
            throw new IllegalStateException("setLicense called with illegal ValidationResult object");
        }
        return this.licenseManager.clearAndSetLicenseNoEvent(validationResult.getLicenseString());
    }

    public void removeLicenses(Iterable<? extends LicenseDetails> licensesToRemove) {
        this.licenseManager.removeLicenses((Iterable)Lists.newArrayList(licensesToRemove));
    }

    @Nonnull
    public Iterable<LicenseDetails> getLicenses() {
        return this.licenseManager.getLicenses();
    }

    private LicenseValidationInformation validateLicenseDetail(@Nonnull LicenseValidationInformation license, @Nonnull I18nHelper i18nHelper) {
        if (!license.isProductKeyValid()) {
            return license.withError(LicenseErrorCode.INVALID_PRODUCT_KEY, i18nHelper.getText(INVALID_PRODUCT_KEY));
        }
        if (!license.isLicenseDetailsValid()) {
            return license.withError(LicenseErrorCode.INVALID_LICENSE_KEY, i18nHelper.getText(INVALID_LICENSE_KEY));
        }
        Optional<LicenseValidationError> error = this.validateSingleLicenseDetails((ApplicationKey)license.getApplicationKey().get(), ((LicenseDetails)license.getLicenseDetail().get()).getLicenseString(), i18nHelper);
        return error.map(e -> license.withError(e.getLicenseErrorCode(), e.getErrorMessage())).orElse(license);
    }

    private Optional<LicenseValidationError> validateSingleLicenseDetails(@Nonnull ApplicationKey applicationKey, @Nonnull String licenseString, @Nonnull I18nHelper i18nHelper) {
        LicenseValidationHelper helper = new LicenseValidationHelper(i18nHelper, this.helpUrls);
        Either errorOrLicenseDetails = helper.decodeLicenseDetails(licenseString, this.licenseManager).flatMap(helper.validateLicenseTypeAndVersion(this.isDataCenterConfigured(), 2)).flatMap(helper.validateLicenseExpiration()).flatMap(helper.validateLicenseUserLimit(applicationKey)).flatMap(helper.validateMaintenanceForApplications(applicationKey, this.applicationManager)).flatMap(helper.validateNonStarterNonEvaluationLicenseChange(this.licenseManager.getLicenses()));
        if (errorOrLicenseDetails.isLeft()) {
            return Optional.ofNullable(errorOrLicenseDetails.left().get());
        }
        return Optional.empty();
    }

    private Set<LicenseValidationInformation> validateHostingTypeCompatibility(@Nonnull Set<LicenseValidationInformation> licenseValidationInformations, @Nonnull I18nHelper i18nHelper) {
        Set newLicenseThatCanBeValidated = licenseValidationInformations.stream().filter(license -> license.needMoreValidation() && !license.isDeleteLicense()).collect(Collectors.toSet());
        if (!newLicenseThatCanBeValidated.isEmpty()) {
            boolean isEndupWithMixHostingType;
            Set newLicenses = newLicenseThatCanBeValidated.stream().map(license -> license.getLicenseDetail()).map(Optional::get).collect(Collectors.toSet());
            Set newApplicationKeys = newLicenses.stream().flatMap(license -> license.getLicensedApplications().getKeys().stream()).collect(Collectors.toSet());
            Set newApplicationKeysThatwillbeDeleted = licenseValidationInformations.stream().filter(license -> license.isDeleteLicense()).filter(license -> license.getLicenseDetail().isPresent()).map(license -> (LicenseDetails)license.getLicenseDetail().get()).flatMap(license -> license.getLicensedApplications().getKeys().stream()).collect(Collectors.toSet());
            Set existingLicenses = StreamSupport.stream(this.licenseManager.getLicenses().spliterator(), false).collect(Collectors.toSet());
            Set existingThatAreNotGetOverrided = existingLicenses.stream().filter(exli -> !newApplicationKeys.containsAll(exli.getLicensedApplications().getKeys())).filter(exli -> !newApplicationKeysThatwillbeDeleted.containsAll(exli.getLicensedApplications().getKeys())).collect(Collectors.toSet());
            Set totalEndResultLicense = Stream.concat(newLicenses.stream(), existingThatAreNotGetOverrided.stream()).collect(Collectors.toSet());
            boolean bl = isEndupWithMixHostingType = totalEndResultLicense.stream().map(LicenseDetails::isDataCenter).distinct().count() > 1L;
            if (isEndupWithMixHostingType) {
                Set invalidLicenseNoNeedtoBeValidated = licenseValidationInformations.stream().filter(license -> !license.needMoreValidation()).collect(Collectors.toSet());
                Optional<Boolean> isDataCenterBaseLineOp = existingThatAreNotGetOverrided.stream().map(LicenseDetails::isDataCenter).findFirst();
                if (isDataCenterBaseLineOp.isPresent()) {
                    boolean isDataCenterBaseLine = isDataCenterBaseLineOp.get();
                    Set validationResults = newLicenseThatCanBeValidated.stream().filter(license -> license.getLicenseDetail().isPresent() && ((LicenseDetails)license.getLicenseDetail().get()).isDataCenter() != isDataCenterBaseLine).map(licenseInfo -> this.getValidationInfoWithHostingTypeError((LicenseValidationInformation)licenseInfo, i18nHelper)).collect(Collectors.toSet());
                    return Stream.concat(invalidLicenseNoNeedtoBeValidated.stream(), validationResults.stream()).collect(Collectors.toSet());
                }
                Set validationResults = newLicenseThatCanBeValidated.stream().map(licenseInfo -> this.getValidationInfoWithHostingTypeError((LicenseValidationInformation)licenseInfo, i18nHelper)).collect(Collectors.toSet());
                return Stream.concat(invalidLicenseNoNeedtoBeValidated.stream(), validationResults.stream()).collect(Collectors.toSet());
            }
        }
        return licenseValidationInformations;
    }

    private LicenseValidationInformation getValidationInfoWithHostingTypeError(@Nonnull LicenseValidationInformation licenseValidationInformation, @Nonnull I18nHelper i18nHelper) {
        String compatibilityLink = "<a href=\"" + this.helpUrls.getUrl("license.compatibility").getUrl() + "\">";
        String htmlCloseTag = "</a>";
        if (this.isDataCenterConfigured()) {
            return licenseValidationInformation.withError(LicenseErrorCode.INCOMPATIBLE_HOSTING_TYPE, i18nHelper.getText("jira.license.validation.not.datacenter.mix", compatibilityLink, "</a>"));
        }
        return licenseValidationInformation.withError(LicenseErrorCode.INCOMPATIBLE_HOSTING_TYPE, i18nHelper.getText("jira.license.validation.datacenter.mix", compatibilityLink, "</a>"));
    }

    private JiraLicenseService.ValidationResult convertResult(@Nonnull LicenseValidationError error, @Nonnull String licenseString) {
        return new OurValidationResult(this.userManager.getTotalUserCount(), licenseString, null, error.getErrorMessage());
    }

    private static final class LicenseValidationHelper {
        private static final String HTML_CLOSE_TAG = "</a>";
        private final I18nHelper i18nHelper;
        @Nonnull
        private final HelpUrls helpUrls;

        public LicenseValidationHelper(@Nonnull I18nHelper i18nHelper, @Nonnull HelpUrls helpUrls) {
            this.i18nHelper = i18nHelper;
            this.helpUrls = helpUrls;
        }

        public static boolean licensesShareAtLeastOneApplication(LicenseDetails license1, LicenseDetails license2) {
            HashSet licenseKeys = new HashSet(license1.getLicensedApplications().getKeys());
            licenseKeys.retainAll(license2.getLicensedApplications().getKeys());
            return !licenseKeys.isEmpty();
        }

        public Optional<LicenseDetails> getLicenseDetails(String licenseString, @Nonnull JiraLicenseManager licenseManager) {
            if (StringUtils.isBlank((CharSequence)licenseString)) {
                return Optional.empty();
            }
            try {
                LicenseDetails jiraLicenseDetails = licenseManager.getLicense(licenseString);
                return Optional.ofNullable(jiraLicenseDetails);
            }
            catch (LicenseException licenseNotDecodable) {
                return Optional.empty();
            }
        }

        public Either<LicenseValidationError, LicenseDetails> decodeLicenseDetails(String licenseString, @Nonnull JiraLicenseManager licenseManager) {
            Optional<LicenseDetails> jiraLicenseDetails = this.getLicenseDetails(licenseString, licenseManager);
            if (jiraLicenseDetails.isPresent()) {
                return Either.right((Object)jiraLicenseDetails.get());
            }
            return Either.left((Object)this.invalidLicenseKeyError());
        }

        public Function<LicenseDetails, Either<LicenseValidationError, LicenseDetails>> validateLicenseExpiration() {
            return jiraLicenseDetails -> {
                if (jiraLicenseDetails.isExpired()) {
                    return Either.left((Object)new LicenseValidationError(LicenseErrorCode.LICENSE_EXPIRED, this.i18nHelper.getText("jira.license.validation.expired")));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        public Function<LicenseDetails, Either<LicenseValidationError, LicenseDetails>> validateLicenseTypeAndVersion(boolean isDataCenterConfigured, int minLicenseVersion) {
            return jiraLicenseDetails -> {
                if (isDataCenterConfigured && !jiraLicenseDetails.isDataCenter()) {
                    return Either.left((Object)new LicenseValidationError(LicenseErrorCode.INCOMPATIBLE_HOSTING_TYPE, this.i18nHelper.getText("jira.license.validation.not.datacenter", this.licenseCompatibilityUrl(), HTML_CLOSE_TAG)));
                }
                if (jiraLicenseDetails.getLicenseVersion() < minLicenseVersion) {
                    return Either.left((Object)new LicenseValidationError(LicenseErrorCode.INCOMPATIBLE_VERSION, this.i18nHelper.getText("setup.error.invalidlicensekey.v1.license.version")));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        private String licenseCompatibilityUrl() {
            return "<a href=\"" + this.helpUrls.getUrl("license.compatibility").getUrl() + "\">";
        }

        public Function<LicenseDetails, Either<LicenseValidationError, LicenseDetails>> validateLicenseUserLimit(@Nonnull ApplicationKey applicationKey) {
            return jiraLicenseDetails -> {
                int licUserLimit;
                LicensedApplications applicationsInLicense = jiraLicenseDetails.getLicensedApplications();
                Set keysInLicense = applicationsInLicense.getKeys();
                if (keysInLicense.isEmpty()) {
                    return Either.left((Object)this.invalidLicenseKeyError());
                }
                if (keysInLicense.contains(applicationKey) && (licUserLimit = applicationsInLicense.getUserLimit(applicationKey)) != -1 && licUserLimit < 1) {
                    return Either.left((Object)new LicenseValidationError(LicenseErrorCode.USER_LIMIT_ISNOT_SET, this.i18nHelper.getText("jira.license.validation.product.user.limit.invalid")));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        public Function<LicenseDetails, Either<LicenseValidationError, LicenseDetails>> validateNonStarterNonEvaluationLicenseChange(@Nonnull Iterable<LicenseDetails> existingLicenses) {
            return jiraLicenseDetails -> {
                if (!jiraLicenseDetails.isStarter() && !jiraLicenseDetails.isEvaluation()) {
                    boolean hasMoreThanOneLicense = false;
                    for (LicenseDetails existingLicense : existingLicenses) {
                        boolean licenseTypesDiffer;
                        if (existingLicense.isStarter() || existingLicense.isEvaluation()) continue;
                        boolean bl = licenseTypesDiffer = existingLicense.isPaidType() != jiraLicenseDetails.isPaidType();
                        if (licenseTypesDiffer && (hasMoreThanOneLicense || !LicenseValidationHelper.licensesShareAtLeastOneApplication(existingLicense, jiraLicenseDetails))) {
                            return Either.left((Object)new LicenseValidationError(LicenseErrorCode.INCOMPATIBLE_LICENSE_TYPE, this.i18nHelper.getText("jira.license.validation.does.not.match.existing.license", jiraLicenseDetails.getLicenseType().name(), existingLicense.getLicenseType().name(), this.licenseCompatibilityUrl(), HTML_CLOSE_TAG)));
                        }
                        hasMoreThanOneLicense = true;
                    }
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        public Function<LicenseDetails, Either<LicenseValidationError, LicenseDetails>> validateMaintenanceForApplications(@Nonnull ApplicationKey installedAppKey, @Nonnull ApplicationManager applicationManager) {
            return jiraLicenseDetails -> {
                LicenseDetails.LicenseStatusMessage maintenanceMessage;
                Option application = applicationManager.getApplication(installedAppKey);
                if (application.isDefined() && !jiraLicenseDetails.isMaintenanceValidForBuildDate(((Application)application.get()).buildDate().toDate()) && (maintenanceMessage = jiraLicenseDetails.getMaintenanceMessage(this.i18nHelper, ((Application)application.get()).getName())).hasAnyMessages()) {
                    return Either.left((Object)new LicenseValidationError(LicenseErrorCode.LICENSE_EXPIRED, maintenanceMessage.getAllMessages("<br/><br/>")));
                }
                return Either.right((Object)jiraLicenseDetails);
            };
        }

        private LicenseValidationError invalidLicenseKeyError() {
            return new LicenseValidationError(LicenseErrorCode.INVALID_LICENSE_KEY, this.i18nHelper.getText(JiraLicenseServiceImpl.INVALID_LICENSE_KEY));
        }
    }

    private static final class OurValidationResult
    implements JiraLicenseService.ValidationResult {
        private static final String LICENSE_FIELD = "license";
        private final SimpleErrorCollection errorCollection;
        private final String licenseString;
        private final LicenseDetails licenseDetails;
        private final int totalUserCount;
        private int licenseVersion;

        public OurValidationResult(int totalUserCount, @Nonnull String licenseString) {
            this(totalUserCount, licenseString, null);
        }

        public OurValidationResult(int totalUserCount, @Nonnull String licenseString, @Nullable LicenseDetails license) {
            this.licenseString = (String)Assertions.notNull((Object)licenseString);
            this.licenseDetails = license;
            this.errorCollection = new SimpleErrorCollection();
            this.totalUserCount = totalUserCount;
            if (this.licenseDetails != null) {
                this.licenseVersion = this.licenseDetails.getLicenseVersion();
            }
        }

        public OurValidationResult(int totalUserCount, @Nullable String licenseString, @Nullable LicenseDetails license, String ... errors) {
            if (licenseString == null && errors.length == 0) {
                throw new IllegalArgumentException("License string can only be null if there are validation errors");
            }
            this.licenseDetails = license;
            this.licenseString = licenseString;
            this.errorCollection = new SimpleErrorCollection();
            this.totalUserCount = totalUserCount;
            if (this.licenseDetails != null) {
                this.licenseVersion = this.licenseDetails.getLicenseVersion();
            }
            for (String error : errors) {
                this.addError(error);
            }
        }

        private void addError(String message) {
            this.errorCollection.addError(LICENSE_FIELD, message);
        }

        public ErrorCollection getErrorCollection() {
            SimpleErrorCollection copied = new SimpleErrorCollection();
            copied.addErrorCollection((ErrorCollection)this.errorCollection);
            return copied;
        }

        @Nullable
        public LicenseDetails getLicenseDetails() {
            return this.licenseDetails;
        }

        public String getLicenseString() {
            return this.licenseString;
        }

        @Deprecated
        public int getLicenseVersion() {
            return this.licenseVersion;
        }

        @Deprecated
        public int getTotalUserCount() {
            return this.totalUserCount;
        }
    }
}

