/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseValidationInformation;
import com.atlassian.sal.api.license.RawProductLicense;
import com.atlassian.sal.api.validate.LicenseErrorCode;
import com.atlassian.sal.api.validate.LicenseValidationError;
import com.atlassian.sal.api.validate.LicenseValidationResult;
import com.atlassian.sal.api.validate.LicenseValidationWarning;
import com.atlassian.sal.api.validate.LicenseWarningCode;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class LicenseValidationInfo
implements LicenseValidationInformation {
    private final RawProductLicense rawProductLicense;
    private final Optional<LicenseDetails> licenseDetail;
    private final LicenseValidationResult licenseValidationResult;

    public LicenseValidationInfo(@Nonnull RawProductLicense rawProductLicense, @Nonnull Optional<LicenseDetails> licenseDetail) {
        this(rawProductLicense, licenseDetail, LicenseValidationResult.withValidResult((Optional)rawProductLicense.getProductKey(), (Optional)rawProductLicense.getLicense()));
    }

    public LicenseValidationInfo(@Nonnull RawProductLicense rawProductLicense, @Nonnull Optional<LicenseDetails> licenseDetail, @Nonnull LicenseValidationResult licenseValidationResult) {
        this.licenseDetail = licenseDetail;
        this.rawProductLicense = rawProductLicense;
        this.licenseValidationResult = licenseValidationResult;
    }

    public Optional<LicenseDetails> getLicenseDetail() {
        return this.licenseDetail;
    }

    public LicenseValidationResult getLicenseValidationResult() {
        return this.licenseValidationResult;
    }

    public boolean isDeleteLicense() {
        return this.rawProductLicense.isDeleteLicense();
    }

    public Optional<ApplicationKey> getApplicationKey() {
        return this.rawProductLicense.getProductKey().filter(pk -> StringUtils.isNotBlank((CharSequence)pk) && ApplicationKey.isValid((String)pk)).map(ApplicationKey::valueOf);
    }

    public boolean isProductKeyValid() {
        return this.getApplicationKey().isPresent();
    }

    public boolean isLicenseDetailsValid() {
        return this.getLicenseDetail().isPresent();
    }

    public boolean isLicensePairWithCorrectProductKey() {
        if (this.getApplicationKey().isPresent()) {
            return this.licenseDetail.map(li -> li.hasApplication(this.getApplicationKey().get())).orElse(false);
        }
        return false;
    }

    public boolean needMoreValidation() {
        return !this.licenseValidationResult.hasErrors() && !this.licenseValidationResult.hasWarnings();
    }

    public LicenseValidationInfo with(@Nonnull LicenseValidationResult licenseValidationResult) {
        return new LicenseValidationInfo(this.rawProductLicense, this.licenseDetail, licenseValidationResult);
    }

    public LicenseValidationInfo withError(@Nonnull LicenseErrorCode licenseErrorCode, @Nonnull String errorMessage) {
        LicenseValidationResult errorResult = LicenseValidationResult.withErrorMessages((Optional)this.rawProductLicense.getProductKey(), (Optional)this.rawProductLicense.getLicense(), (Iterable)Sets.newHashSet((Object[])new LicenseValidationError[]{new LicenseValidationError(licenseErrorCode, errorMessage)}));
        return new LicenseValidationInfo(this.rawProductLicense, this.licenseDetail, errorResult);
    }

    public LicenseValidationInfo withWarning(@Nonnull LicenseWarningCode licenseWarningCode, @Nonnull String warningMessage) {
        LicenseValidationResult warningResult = LicenseValidationResult.withWarningMessages((Optional)this.rawProductLicense.getProductKey(), (Optional)this.rawProductLicense.getLicense(), (Iterable)Sets.newHashSet((Object[])new LicenseValidationWarning[]{new LicenseValidationWarning(licenseWarningCode, warningMessage)}));
        return new LicenseValidationInfo(this.rawProductLicense, this.licenseDetail, warningResult);
    }

    public LicenseValidationInfo withWarnings(@Nonnull Set<LicenseValidationWarning> warnings) {
        LicenseValidationResult warningResult = LicenseValidationResult.withWarningMessages((Optional)this.rawProductLicense.getProductKey(), (Optional)this.rawProductLicense.getLicense(), warnings);
        return new LicenseValidationInfo(this.rawProductLicense, this.licenseDetail, warningResult);
    }
}

