/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.event.project.ProjectEventManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import java.util.concurrent.Callable;

public class DeleteProjectCommand
implements Callable<ProjectService.DeleteProjectResult>,
ProvidesTaskProgress {
    private final ProjectManager projectManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final VersionManager versionManager;
    private final ProjectComponentManager projectComponentManager;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private final I18nHelper.BeanFactory i18nFactory;
    private final WorkflowManager workflowManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final ProjectEventManager projectEventManager;
    private final IssueManager issueManager;
    private ApplicationUser user;
    private final Project project;
    private ErrorCollection errorCollection;
    private TaskProgressSink taskProgressSink;

    public DeleteProjectCommand(ProjectManager projectManager, WorkflowSchemeManager workflowSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, CustomFieldManager customFieldManager, NodeAssociationStore nodeAssociationStore, VersionManager versionManager, ProjectComponentManager projectComponentManager, SharePermissionDeleteUtils sharePermissionDeleteUtils, I18nHelper.BeanFactory i18nFactory, WorkflowManager workflowManager, PermissionSchemeManager permissionSchemeManager, ProjectEventManager projectEventManager, IssueManager issueManager, ApplicationUser user, Project project) {
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.customFieldManager = customFieldManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.versionManager = versionManager;
        this.projectComponentManager = projectComponentManager;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.i18nFactory = i18nFactory;
        this.workflowManager = workflowManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.projectEventManager = projectEventManager;
        this.issueManager = issueManager;
        this.user = user;
        this.project = project;
    }

    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectService.DeleteProjectResult call() {
        I18nHelper i18nBean = this.getI18nBean(this.user);
        this.permissionSchemeManager.removeSchemesFromProject(this.project);
        long size = this.issueManager.getIssueCountForProject(this.project.getId()) * 110L / 100L;
        size = Math.max(size, 200L);
        ProgressManager progressManager = new ProgressManager(size);
        Context context = Contexts.builder().sized((Sized)new FixedSized((int)size)).progress(this.taskProgressSink, i18nBean, "", "admin.projects.delete.project.subtask").build();
        this.errorCollection = ErrorCollections.empty();
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.issues"));
        try {
            this.projectManager.removeProjectIssues(this.project, context);
        }
        catch (RemoveException e) {
            this.errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult(this.errorCollection);
        }
        progressManager.progressToPercentage(context, 90);
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.custom.fields"));
        Context.Task task = context.start((Object)this.project);
        try {
            this.customFieldManager.removeProjectAssociations(this.project);
        }
        finally {
            task.complete();
        }
        progressManager.progressByPercentage(context, 2);
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.screens"));
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(this.project);
        this.issueTypeScreenSchemeManager.removeSchemeAssociation(this.project, issueTypeScreenScheme);
        progressManager.progressByPercentage(context, 1);
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.components.and.versions"));
        try {
            this.nodeAssociationStore.removeAllAssociationsFromSource("Project", this.project.getId());
            this.versionManager.deleteAllVersions(this.project.getId());
            this.projectComponentManager.deleteAllComponents(this.project.getId());
        }
        catch (DataAccessException e) {
            this.errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult(this.errorCollection);
        }
        progressManager.progressByPercentage(context, 2);
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.permissions"));
        this.sharePermissionDeleteUtils.deleteProjectSharePermissions(this.project.getId());
        progressManager.progressByPercentage(context, 1);
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.draft.workflows"));
        this.workflowSchemeManager.cleanUpSchemeDraft(this.project, this.user);
        progressManager.progressByPercentage(context, 1);
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.project"));
        this.projectManager.removeProject(this.project);
        this.projectManager.refresh();
        progressManager.progressByPercentage(context, 1);
        context.setName(i18nBean.getText("admin.projects.delete.project.step.remove.workflows"));
        Scheme workflowScheme = this.workflowSchemeManager.getSchemeFor(this.project);
        Iterable workflowsAssociatedToProject = this.workflowManager.getWorkflowsFromScheme(workflowScheme);
        this.workflowSchemeManager.clearWorkflowCache();
        this.workflowManager.copyAndDeleteDraftsForInactiveWorkflowsIn(this.user, workflowsAssociatedToProject);
        progressManager.progressByPercentage(context, 1);
        this.projectEventManager.dispatchProjectDeleted(this.user, this.project);
        progressManager.progressByPercentage(context, 100);
        return new ProjectService.DeleteProjectResult(this.errorCollection);
    }

    protected final I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    private static class ProgressManager {
        final long size;

        private ProgressManager(long size) {
            this.size = size;
        }

        void progressByPercentage(Context context, int percent) {
            long tasks = this.size * (long)percent / 100L;
            long remaining = context.getNumberOfTasksToCompletion();
            long i = 0L;
            while (i < Math.min(tasks, remaining) & i < this.size) {
                context.start(null).complete();
                ++i;
            }
        }

        void progressToPercentage(Context context, int percent) {
            long done;
            long tasksForPercentComplete = this.size * (long)percent / 100L;
            long remaining = context.getNumberOfTasksToCompletion();
            long i = done = this.size - remaining;
            while (i < tasksForPercentComplete & i < this.size) {
                context.start(null).complete();
                ++i;
            }
        }
    }
}

